// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.wellarchitected.model.CreateWorkloadResponse
import aws.sdk.kotlin.services.wellarchitected.model.WellArchitectedException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateWorkloadOperationDeserializer: HttpDeserialize<CreateWorkloadResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateWorkloadResponse {
        if (!response.status.isSuccess()) {
            throwCreateWorkloadError(context, response)
        }
        val builder = CreateWorkloadResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateWorkloadOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateWorkloadError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WellArchitectedException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WellArchitectedException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateWorkloadOperationBody(builder: CreateWorkloadResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val WORKLOADARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WorkloadArn"))
    val WORKLOADID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WorkloadId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(WORKLOADARN_DESCRIPTOR)
        field(WORKLOADID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                WORKLOADARN_DESCRIPTOR.index -> builder.workloadArn = deserializeString()
                WORKLOADID_DESCRIPTOR.index -> builder.workloadId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
