// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.paginators

import aws.sdk.kotlin.services.wellarchitected.WellArchitectedClient
import aws.sdk.kotlin.services.wellarchitected.model.ListAnswersRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListAnswersResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListCheckDetailsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListCheckDetailsResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListCheckSummariesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListCheckSummariesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListLensReviewImprovementsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListLensReviewImprovementsResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListLensReviewsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListLensReviewsResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListLensSharesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListLensSharesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListLensesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListLensesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListMilestonesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListMilestonesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListNotificationsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListNotificationsResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListShareInvitationsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListShareInvitationsResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListWorkloadSharesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListWorkloadSharesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListWorkloadsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListWorkloadsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListAnswersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAnswersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnswersResponse]
 */
public fun WellArchitectedClient.listAnswersPaginated(initialRequest: ListAnswersRequest): Flow<ListAnswersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAnswersPaginated.listAnswers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAnswersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnswersResponse]
 */
public fun WellArchitectedClient.listAnswersPaginated(block: ListAnswersRequest.Builder.() -> Unit): Flow<ListAnswersResponse> =
    listAnswersPaginated(ListAnswersRequest.Builder().apply(block).build())

/**
 * Paginate over [ListCheckDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCheckDetailsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCheckDetailsResponse]
 */
public fun WellArchitectedClient.listCheckDetailsPaginated(initialRequest: ListCheckDetailsRequest): Flow<ListCheckDetailsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCheckDetailsPaginated.listCheckDetails(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCheckDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCheckDetailsResponse]
 */
public fun WellArchitectedClient.listCheckDetailsPaginated(block: ListCheckDetailsRequest.Builder.() -> Unit): Flow<ListCheckDetailsResponse> =
    listCheckDetailsPaginated(ListCheckDetailsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListCheckSummariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCheckSummariesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCheckSummariesResponse]
 */
public fun WellArchitectedClient.listCheckSummariesPaginated(initialRequest: ListCheckSummariesRequest): Flow<ListCheckSummariesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCheckSummariesPaginated.listCheckSummaries(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCheckSummariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCheckSummariesResponse]
 */
public fun WellArchitectedClient.listCheckSummariesPaginated(block: ListCheckSummariesRequest.Builder.() -> Unit): Flow<ListCheckSummariesResponse> =
    listCheckSummariesPaginated(ListCheckSummariesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListLensesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLensesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLensesResponse]
 */
public fun WellArchitectedClient.listLensesPaginated(initialRequest: ListLensesRequest): Flow<ListLensesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLensesPaginated.listLenses(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListLensesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLensesResponse]
 */
public fun WellArchitectedClient.listLensesPaginated(block: ListLensesRequest.Builder.() -> Unit): Flow<ListLensesResponse> =
    listLensesPaginated(ListLensesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListLensReviewImprovementsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLensReviewImprovementsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLensReviewImprovementsResponse]
 */
public fun WellArchitectedClient.listLensReviewImprovementsPaginated(initialRequest: ListLensReviewImprovementsRequest): Flow<ListLensReviewImprovementsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLensReviewImprovementsPaginated.listLensReviewImprovements(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListLensReviewImprovementsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLensReviewImprovementsResponse]
 */
public fun WellArchitectedClient.listLensReviewImprovementsPaginated(block: ListLensReviewImprovementsRequest.Builder.() -> Unit): Flow<ListLensReviewImprovementsResponse> =
    listLensReviewImprovementsPaginated(ListLensReviewImprovementsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListLensReviewsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLensReviewsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLensReviewsResponse]
 */
public fun WellArchitectedClient.listLensReviewsPaginated(initialRequest: ListLensReviewsRequest): Flow<ListLensReviewsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLensReviewsPaginated.listLensReviews(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListLensReviewsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLensReviewsResponse]
 */
public fun WellArchitectedClient.listLensReviewsPaginated(block: ListLensReviewsRequest.Builder.() -> Unit): Flow<ListLensReviewsResponse> =
    listLensReviewsPaginated(ListLensReviewsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListLensSharesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLensSharesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLensSharesResponse]
 */
public fun WellArchitectedClient.listLensSharesPaginated(initialRequest: ListLensSharesRequest): Flow<ListLensSharesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLensSharesPaginated.listLensShares(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListLensSharesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLensSharesResponse]
 */
public fun WellArchitectedClient.listLensSharesPaginated(block: ListLensSharesRequest.Builder.() -> Unit): Flow<ListLensSharesResponse> =
    listLensSharesPaginated(ListLensSharesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMilestonesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMilestonesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMilestonesResponse]
 */
public fun WellArchitectedClient.listMilestonesPaginated(initialRequest: ListMilestonesRequest): Flow<ListMilestonesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMilestonesPaginated.listMilestones(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListMilestonesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMilestonesResponse]
 */
public fun WellArchitectedClient.listMilestonesPaginated(block: ListMilestonesRequest.Builder.() -> Unit): Flow<ListMilestonesResponse> =
    listMilestonesPaginated(ListMilestonesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListNotificationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNotificationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNotificationsResponse]
 */
public fun WellArchitectedClient.listNotificationsPaginated(initialRequest: ListNotificationsRequest): Flow<ListNotificationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNotificationsPaginated.listNotifications(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListNotificationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNotificationsResponse]
 */
public fun WellArchitectedClient.listNotificationsPaginated(block: ListNotificationsRequest.Builder.() -> Unit): Flow<ListNotificationsResponse> =
    listNotificationsPaginated(ListNotificationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListShareInvitationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListShareInvitationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListShareInvitationsResponse]
 */
public fun WellArchitectedClient.listShareInvitationsPaginated(initialRequest: ListShareInvitationsRequest): Flow<ListShareInvitationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listShareInvitationsPaginated.listShareInvitations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListShareInvitationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListShareInvitationsResponse]
 */
public fun WellArchitectedClient.listShareInvitationsPaginated(block: ListShareInvitationsRequest.Builder.() -> Unit): Flow<ListShareInvitationsResponse> =
    listShareInvitationsPaginated(ListShareInvitationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListWorkloadsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkloadsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkloadsResponse]
 */
public fun WellArchitectedClient.listWorkloadsPaginated(initialRequest: ListWorkloadsRequest): Flow<ListWorkloadsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkloadsPaginated.listWorkloads(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkloadsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkloadsResponse]
 */
public fun WellArchitectedClient.listWorkloadsPaginated(block: ListWorkloadsRequest.Builder.() -> Unit): Flow<ListWorkloadsResponse> =
    listWorkloadsPaginated(ListWorkloadsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListWorkloadSharesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkloadSharesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkloadSharesResponse]
 */
public fun WellArchitectedClient.listWorkloadSharesPaginated(initialRequest: ListWorkloadSharesRequest): Flow<ListWorkloadSharesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkloadSharesPaginated.listWorkloadShares(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkloadSharesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkloadSharesResponse]
 */
public fun WellArchitectedClient.listWorkloadSharesPaginated(block: ListWorkloadSharesRequest.Builder.() -> Unit): Flow<ListWorkloadSharesResponse> =
    listWorkloadSharesPaginated(ListWorkloadSharesRequest.Builder().apply(block).build())
