// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.model



/**
 * Input for update lens review.
 */
public class UpdateLensReviewRequest private constructor(builder: Builder) {
    /**
     * The alias of the lens.
     *
     * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-west-2::lens/serverless`.
     *
     * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-east-1:123456789012:lens/my-lens`.
     *
     * Each lens is identified by its LensSummary$LensAlias.
     */
    public val lensAlias: kotlin.String? = requireNotNull(builder.lensAlias) { "A non-null value must be provided for lensAlias" }
    /**
     * The notes associated with the workload.
     */
    public val lensNotes: kotlin.String? = builder.lensNotes
    /**
     * List of pillar notes of a lens review in a workload.
     */
    public val pillarNotes: Map<String, String>? = builder.pillarNotes
    /**
     * The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.
     */
    public val workloadId: kotlin.String? = requireNotNull(builder.workloadId) { "A non-null value must be provided for workloadId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wellarchitected.model.UpdateLensReviewRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateLensReviewRequest(")
        append("lensAlias=$lensAlias,")
        append("lensNotes=$lensNotes,")
        append("pillarNotes=$pillarNotes,")
        append("workloadId=$workloadId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lensAlias?.hashCode() ?: 0
        result = 31 * result + (lensNotes?.hashCode() ?: 0)
        result = 31 * result + (pillarNotes?.hashCode() ?: 0)
        result = 31 * result + (workloadId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateLensReviewRequest

        if (lensAlias != other.lensAlias) return false
        if (lensNotes != other.lensNotes) return false
        if (pillarNotes != other.pillarNotes) return false
        if (workloadId != other.workloadId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wellarchitected.model.UpdateLensReviewRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The alias of the lens.
         *
         * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-west-2::lens/serverless`.
         *
         * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-east-1:123456789012:lens/my-lens`.
         *
         * Each lens is identified by its LensSummary$LensAlias.
         */
        public var lensAlias: kotlin.String? = null
        /**
         * The notes associated with the workload.
         */
        public var lensNotes: kotlin.String? = null
        /**
         * List of pillar notes of a lens review in a workload.
         */
        public var pillarNotes: Map<String, String>? = null
        /**
         * The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.
         */
        public var workloadId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wellarchitected.model.UpdateLensReviewRequest) : this() {
            this.lensAlias = x.lensAlias
            this.lensNotes = x.lensNotes
            this.pillarNotes = x.pillarNotes
            this.workloadId = x.workloadId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wellarchitected.model.UpdateLensReviewRequest = UpdateLensReviewRequest(this)
    }
}
