// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A lens review of a question.
 */
public class LensReview private constructor(builder: Builder) {
    /**
     * The alias of the lens.
     *
     * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-west-2::lens/serverless`.
     *
     * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-east-1:123456789012:lens/my-lens`.
     *
     * Each lens is identified by its LensSummary$LensAlias.
     */
    public val lensAlias: kotlin.String? = builder.lensAlias
    /**
     * The ARN for the lens.
     */
    public val lensArn: kotlin.String? = builder.lensArn
    /**
     * The full name of the lens.
     */
    public val lensName: kotlin.String? = builder.lensName
    /**
     * The status of the lens.
     */
    public val lensStatus: aws.sdk.kotlin.services.wellarchitected.model.LensStatus? = builder.lensStatus
    /**
     * The version of the lens.
     */
    public val lensVersion: kotlin.String? = builder.lensVersion
    /**
     * The token to use to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The notes associated with the workload.
     */
    public val notes: kotlin.String? = builder.notes
    /**
     * List of pillar review summaries of lens review in a workload.
     */
    public val pillarReviewSummaries: List<PillarReviewSummary>? = builder.pillarReviewSummaries
    /**
     * A map from risk names to the count of how questions have that rating.
     */
    public val riskCounts: Map<String, Int>? = builder.riskCounts
    /**
     * The date and time recorded.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wellarchitected.model.LensReview = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LensReview(")
        append("lensAlias=$lensAlias,")
        append("lensArn=$lensArn,")
        append("lensName=$lensName,")
        append("lensStatus=$lensStatus,")
        append("lensVersion=$lensVersion,")
        append("nextToken=$nextToken,")
        append("notes=$notes,")
        append("pillarReviewSummaries=$pillarReviewSummaries,")
        append("riskCounts=$riskCounts,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lensAlias?.hashCode() ?: 0
        result = 31 * result + (lensArn?.hashCode() ?: 0)
        result = 31 * result + (lensName?.hashCode() ?: 0)
        result = 31 * result + (lensStatus?.hashCode() ?: 0)
        result = 31 * result + (lensVersion?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (notes?.hashCode() ?: 0)
        result = 31 * result + (pillarReviewSummaries?.hashCode() ?: 0)
        result = 31 * result + (riskCounts?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LensReview

        if (lensAlias != other.lensAlias) return false
        if (lensArn != other.lensArn) return false
        if (lensName != other.lensName) return false
        if (lensStatus != other.lensStatus) return false
        if (lensVersion != other.lensVersion) return false
        if (nextToken != other.nextToken) return false
        if (notes != other.notes) return false
        if (pillarReviewSummaries != other.pillarReviewSummaries) return false
        if (riskCounts != other.riskCounts) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wellarchitected.model.LensReview = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The alias of the lens.
         *
         * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-west-2::lens/serverless`.
         *
         * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-east-1:123456789012:lens/my-lens`.
         *
         * Each lens is identified by its LensSummary$LensAlias.
         */
        public var lensAlias: kotlin.String? = null
        /**
         * The ARN for the lens.
         */
        public var lensArn: kotlin.String? = null
        /**
         * The full name of the lens.
         */
        public var lensName: kotlin.String? = null
        /**
         * The status of the lens.
         */
        public var lensStatus: aws.sdk.kotlin.services.wellarchitected.model.LensStatus? = null
        /**
         * The version of the lens.
         */
        public var lensVersion: kotlin.String? = null
        /**
         * The token to use to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The notes associated with the workload.
         */
        public var notes: kotlin.String? = null
        /**
         * List of pillar review summaries of lens review in a workload.
         */
        public var pillarReviewSummaries: List<PillarReviewSummary>? = null
        /**
         * A map from risk names to the count of how questions have that rating.
         */
        public var riskCounts: Map<String, Int>? = null
        /**
         * The date and time recorded.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wellarchitected.model.LensReview) : this() {
            this.lensAlias = x.lensAlias
            this.lensArn = x.lensArn
            this.lensName = x.lensName
            this.lensStatus = x.lensStatus
            this.lensVersion = x.lensVersion
            this.nextToken = x.nextToken
            this.notes = x.notes
            this.pillarReviewSummaries = x.pillarReviewSummaries
            this.riskCounts = x.riskCounts
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wellarchitected.model.LensReview = LensReview(this)
    }
}
