// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.model



/**
 * Input for workload creation.
 */
public class CreateWorkloadRequest private constructor(builder: Builder) {
    /**
     * The list of Amazon Web Services account IDs associated with the workload.
     */
    public val accountIds: List<String>? = builder.accountIds
    /**
     * List of AppRegistry application ARNs associated to the workload.
     */
    public val applications: List<String>? = builder.applications
    /**
     * The URL of the architectural design for the workload.
     */
    public val architecturalDesign: kotlin.String? = builder.architecturalDesign
    /**
     * The list of Amazon Web Services Regions associated with the workload, for example, `us-east-2`, or `ca-central-1`.
     */
    public val awsRegions: List<String>? = builder.awsRegions
    /**
     * A unique case-sensitive string used to ensure that this request is idempotent (executes only once).
     *
     * You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned.
     *
     * This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The description for the workload.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Well-Architected discovery configuration settings associated to the workload.
     */
    public val discoveryConfig: aws.sdk.kotlin.services.wellarchitected.model.WorkloadDiscoveryConfig? = builder.discoveryConfig
    /**
     * The environment for the workload.
     */
    public val environment: aws.sdk.kotlin.services.wellarchitected.model.WorkloadEnvironment? = builder.environment
    /**
     * The industry for the workload.
     */
    public val industry: kotlin.String? = builder.industry
    /**
     * The industry type for the workload.
     *
     * If specified, must be one of the following:
     * + `Agriculture`
     * + `Automobile`
     * + `Defense`
     * + `Design and Engineering`
     * + `Digital Advertising`
     * + `Education`
     * + `Environmental Protection`
     * + `Financial Services`
     * + `Gaming`
     * + `General Public Services`
     * + `Healthcare`
     * + `Hospitality`
     * + `InfoTech`
     * + `Justice and Public Safety`
     * + `Life Sciences`
     * + `Manufacturing`
     * + `Media & Entertainment`
     * + `Mining & Resources`
     * + `Oil & Gas`
     * + `Power & Utilities`
     * + `Professional Services`
     * + `Real Estate & Construction`
     * + `Retail & Wholesale`
     * + `Social Protection`
     * + `Telecommunications`
     * + `Travel, Transportation & Logistics`
     * + `Other`
     */
    public val industryType: kotlin.String? = builder.industryType
    /**
     * The list of lenses associated with the workload. Each lens is identified by its LensSummary$LensAlias.
     */
    public val lenses: List<String>? = builder.lenses
    /**
     * The list of non-Amazon Web Services Regions associated with the workload.
     */
    public val nonAwsRegions: List<String>? = builder.nonAwsRegions
    /**
     * The notes associated with the workload.
     */
    public val notes: kotlin.String? = builder.notes
    /**
     * The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its PillarReviewSummary$PillarId.
     */
    public val pillarPriorities: List<String>? = builder.pillarPriorities
    /**
     * The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.
     */
    public val reviewOwner: kotlin.String? = builder.reviewOwner
    /**
     * The tags to be associated with the workload.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The name of the workload.
     *
     * The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.
     */
    public val workloadName: kotlin.String? = builder.workloadName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wellarchitected.model.CreateWorkloadRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateWorkloadRequest(")
        append("accountIds=$accountIds,")
        append("applications=$applications,")
        append("architecturalDesign=$architecturalDesign,")
        append("awsRegions=$awsRegions,")
        append("clientRequestToken=$clientRequestToken,")
        append("description=$description,")
        append("discoveryConfig=$discoveryConfig,")
        append("environment=$environment,")
        append("industry=$industry,")
        append("industryType=$industryType,")
        append("lenses=$lenses,")
        append("nonAwsRegions=$nonAwsRegions,")
        append("notes=$notes,")
        append("pillarPriorities=$pillarPriorities,")
        append("reviewOwner=$reviewOwner,")
        append("tags=$tags,")
        append("workloadName=$workloadName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIds?.hashCode() ?: 0
        result = 31 * result + (applications?.hashCode() ?: 0)
        result = 31 * result + (architecturalDesign?.hashCode() ?: 0)
        result = 31 * result + (awsRegions?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (discoveryConfig?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (industry?.hashCode() ?: 0)
        result = 31 * result + (industryType?.hashCode() ?: 0)
        result = 31 * result + (lenses?.hashCode() ?: 0)
        result = 31 * result + (nonAwsRegions?.hashCode() ?: 0)
        result = 31 * result + (notes?.hashCode() ?: 0)
        result = 31 * result + (pillarPriorities?.hashCode() ?: 0)
        result = 31 * result + (reviewOwner?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workloadName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateWorkloadRequest

        if (accountIds != other.accountIds) return false
        if (applications != other.applications) return false
        if (architecturalDesign != other.architecturalDesign) return false
        if (awsRegions != other.awsRegions) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (description != other.description) return false
        if (discoveryConfig != other.discoveryConfig) return false
        if (environment != other.environment) return false
        if (industry != other.industry) return false
        if (industryType != other.industryType) return false
        if (lenses != other.lenses) return false
        if (nonAwsRegions != other.nonAwsRegions) return false
        if (notes != other.notes) return false
        if (pillarPriorities != other.pillarPriorities) return false
        if (reviewOwner != other.reviewOwner) return false
        if (tags != other.tags) return false
        if (workloadName != other.workloadName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wellarchitected.model.CreateWorkloadRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of Amazon Web Services account IDs associated with the workload.
         */
        public var accountIds: List<String>? = null
        /**
         * List of AppRegistry application ARNs associated to the workload.
         */
        public var applications: List<String>? = null
        /**
         * The URL of the architectural design for the workload.
         */
        public var architecturalDesign: kotlin.String? = null
        /**
         * The list of Amazon Web Services Regions associated with the workload, for example, `us-east-2`, or `ca-central-1`.
         */
        public var awsRegions: List<String>? = null
        /**
         * A unique case-sensitive string used to ensure that this request is idempotent (executes only once).
         *
         * You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned.
         *
         * This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The description for the workload.
         */
        public var description: kotlin.String? = null
        /**
         * Well-Architected discovery configuration settings associated to the workload.
         */
        public var discoveryConfig: aws.sdk.kotlin.services.wellarchitected.model.WorkloadDiscoveryConfig? = null
        /**
         * The environment for the workload.
         */
        public var environment: aws.sdk.kotlin.services.wellarchitected.model.WorkloadEnvironment? = null
        /**
         * The industry for the workload.
         */
        public var industry: kotlin.String? = null
        /**
         * The industry type for the workload.
         *
         * If specified, must be one of the following:
         * + `Agriculture`
         * + `Automobile`
         * + `Defense`
         * + `Design and Engineering`
         * + `Digital Advertising`
         * + `Education`
         * + `Environmental Protection`
         * + `Financial Services`
         * + `Gaming`
         * + `General Public Services`
         * + `Healthcare`
         * + `Hospitality`
         * + `InfoTech`
         * + `Justice and Public Safety`
         * + `Life Sciences`
         * + `Manufacturing`
         * + `Media & Entertainment`
         * + `Mining & Resources`
         * + `Oil & Gas`
         * + `Power & Utilities`
         * + `Professional Services`
         * + `Real Estate & Construction`
         * + `Retail & Wholesale`
         * + `Social Protection`
         * + `Telecommunications`
         * + `Travel, Transportation & Logistics`
         * + `Other`
         */
        public var industryType: kotlin.String? = null
        /**
         * The list of lenses associated with the workload. Each lens is identified by its LensSummary$LensAlias.
         */
        public var lenses: List<String>? = null
        /**
         * The list of non-Amazon Web Services Regions associated with the workload.
         */
        public var nonAwsRegions: List<String>? = null
        /**
         * The notes associated with the workload.
         */
        public var notes: kotlin.String? = null
        /**
         * The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its PillarReviewSummary$PillarId.
         */
        public var pillarPriorities: List<String>? = null
        /**
         * The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.
         */
        public var reviewOwner: kotlin.String? = null
        /**
         * The tags to be associated with the workload.
         */
        public var tags: Map<String, String>? = null
        /**
         * The name of the workload.
         *
         * The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.
         */
        public var workloadName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wellarchitected.model.CreateWorkloadRequest) : this() {
            this.accountIds = x.accountIds
            this.applications = x.applications
            this.architecturalDesign = x.architecturalDesign
            this.awsRegions = x.awsRegions
            this.clientRequestToken = x.clientRequestToken
            this.description = x.description
            this.discoveryConfig = x.discoveryConfig
            this.environment = x.environment
            this.industry = x.industry
            this.industryType = x.industryType
            this.lenses = x.lenses
            this.nonAwsRegions = x.nonAwsRegions
            this.notes = x.notes
            this.pillarPriorities = x.pillarPriorities
            this.reviewOwner = x.reviewOwner
            this.tags = x.tags
            this.workloadName = x.workloadName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wellarchitected.model.CreateWorkloadRequest = CreateWorkloadRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.wellarchitected.model.WorkloadDiscoveryConfig] inside the given [block]
         */
        public fun discoveryConfig(block: aws.sdk.kotlin.services.wellarchitected.model.WorkloadDiscoveryConfig.Builder.() -> kotlin.Unit) {
            this.discoveryConfig = aws.sdk.kotlin.services.wellarchitected.model.WorkloadDiscoveryConfig.invoke(block)
        }
    }
}
