// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.wellarchitected.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.wellarchitected.model.*
import aws.sdk.kotlin.services.wellarchitected.model.AssociateLensesRequest
import aws.sdk.kotlin.services.wellarchitected.model.AssociateLensesResponse
import aws.sdk.kotlin.services.wellarchitected.model.CreateLensShareRequest
import aws.sdk.kotlin.services.wellarchitected.model.CreateLensShareResponse
import aws.sdk.kotlin.services.wellarchitected.model.CreateLensVersionRequest
import aws.sdk.kotlin.services.wellarchitected.model.CreateLensVersionResponse
import aws.sdk.kotlin.services.wellarchitected.model.CreateMilestoneRequest
import aws.sdk.kotlin.services.wellarchitected.model.CreateMilestoneResponse
import aws.sdk.kotlin.services.wellarchitected.model.CreateWorkloadRequest
import aws.sdk.kotlin.services.wellarchitected.model.CreateWorkloadResponse
import aws.sdk.kotlin.services.wellarchitected.model.CreateWorkloadShareRequest
import aws.sdk.kotlin.services.wellarchitected.model.CreateWorkloadShareResponse
import aws.sdk.kotlin.services.wellarchitected.model.DeleteLensRequest
import aws.sdk.kotlin.services.wellarchitected.model.DeleteLensResponse
import aws.sdk.kotlin.services.wellarchitected.model.DeleteLensShareRequest
import aws.sdk.kotlin.services.wellarchitected.model.DeleteLensShareResponse
import aws.sdk.kotlin.services.wellarchitected.model.DeleteWorkloadRequest
import aws.sdk.kotlin.services.wellarchitected.model.DeleteWorkloadResponse
import aws.sdk.kotlin.services.wellarchitected.model.DeleteWorkloadShareRequest
import aws.sdk.kotlin.services.wellarchitected.model.DeleteWorkloadShareResponse
import aws.sdk.kotlin.services.wellarchitected.model.DisassociateLensesRequest
import aws.sdk.kotlin.services.wellarchitected.model.DisassociateLensesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ExportLensRequest
import aws.sdk.kotlin.services.wellarchitected.model.ExportLensResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetAnswerRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetAnswerResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetLensRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetLensResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetLensReviewReportRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetLensReviewReportResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetLensReviewRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetLensReviewResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetLensVersionDifferenceRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetLensVersionDifferenceResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetMilestoneRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetMilestoneResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetWorkloadRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetWorkloadResponse
import aws.sdk.kotlin.services.wellarchitected.model.ImportLensRequest
import aws.sdk.kotlin.services.wellarchitected.model.ImportLensResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListAnswersRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListAnswersResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListCheckDetailsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListCheckDetailsResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListCheckSummariesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListCheckSummariesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListLensReviewImprovementsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListLensReviewImprovementsResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListLensReviewsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListLensReviewsResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListLensSharesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListLensSharesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListLensesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListLensesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListMilestonesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListMilestonesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListNotificationsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListNotificationsResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListShareInvitationsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListShareInvitationsResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListWorkloadSharesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListWorkloadSharesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListWorkloadsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListWorkloadsResponse
import aws.sdk.kotlin.services.wellarchitected.model.TagResourceRequest
import aws.sdk.kotlin.services.wellarchitected.model.TagResourceResponse
import aws.sdk.kotlin.services.wellarchitected.model.UntagResourceRequest
import aws.sdk.kotlin.services.wellarchitected.model.UntagResourceResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateAnswerRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateAnswerResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateGlobalSettingsRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateGlobalSettingsResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateLensReviewRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateLensReviewResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateShareInvitationRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateShareInvitationResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateWorkloadRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateWorkloadResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateWorkloadShareRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateWorkloadShareResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpgradeLensReviewRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpgradeLensReviewResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Well-Architected Tool
 * This is the *Well-Architected Tool API Reference*. The WA Tool API provides programmatic access to the [Well-Architected Tool](http://aws.amazon.com/well-architected-tool) in the [Amazon Web Services Management Console](https://console.aws.amazon.com/wellarchitected). For information about the Well-Architected Tool, see the [Well-Architected Tool User Guide](https://docs.aws.amazon.com/wellarchitected/latest/userguide/intro.html).
 */
public interface WellArchitectedClient : SdkClient {

    override val serviceName: String
        get() = "WellArchitected"
    /**
     * WellArchitectedClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): WellArchitectedClient {
            val config = Config.Builder().apply(block).build()
            return DefaultWellArchitectedClient(config)
        }

        public operator fun invoke(config: Config): WellArchitectedClient = DefaultWellArchitectedClient(config)

        /**
         * Construct a [WellArchitectedClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): WellArchitectedClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultWellArchitectedClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associate a lens to a workload.
     *
     * Up to 10 lenses can be associated with a workload in a single API operation. A maximum of 20 lenses can be associated with a workload.
     *
     * **Disclaimer**
     *
     * By accessing and/or applying custom lenses created by another Amazon Web Services user or account, you acknowledge that custom lenses created by other users and shared with you are Third Party Content as defined in the Amazon Web Services Customer Agreement.
     */
    public suspend fun associateLenses(input: AssociateLensesRequest): AssociateLensesResponse

    /**
     * Create a lens share.
     *
     * The owner of a lens can share it with other Amazon Web Services accounts, IAM users, an organization, and organizational units (OUs) in the same Amazon Web Services Region. Shared access to a lens is not removed until the lens invitation is deleted.
     *
     * **Disclaimer**
     *
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.
     */
    public suspend fun createLensShare(input: CreateLensShareRequest): CreateLensShareResponse

    /**
     * Create a new lens version.
     *
     * A lens can have up to 100 versions.
     *
     * After a lens has been imported, create a new lens version to publish it. The owner of a lens can share the lens with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Only the owner of a lens can delete it.
     */
    public suspend fun createLensVersion(input: CreateLensVersionRequest): CreateLensVersionResponse

    /**
     * Create a milestone for an existing workload.
     */
    public suspend fun createMilestone(input: CreateMilestoneRequest): CreateMilestoneResponse

    /**
     * Create a new workload.
     *
     * The owner of a workload can share the workload with other Amazon Web Services accounts, IAM users, an organization, and organizational units (OUs) in the same Amazon Web Services Region. Only the owner of a workload can delete it.
     *
     * For more information, see [Defining a Workload](https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html) in the *Well-Architected Tool User Guide*.
     */
    public suspend fun createWorkload(input: CreateWorkloadRequest): CreateWorkloadResponse

    /**
     * Create a workload share.
     *
     * The owner of a workload can share it with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Shared access to a workload is not removed until the workload invitation is deleted.
     *
     * For more information, see [Sharing a Workload](https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html) in the *Well-Architected Tool User Guide*.
     */
    public suspend fun createWorkloadShare(input: CreateWorkloadShareRequest): CreateWorkloadShareResponse

    /**
     * Delete an existing lens.
     *
     * Only the owner of a lens can delete it. After the lens is deleted, Amazon Web Services accounts and IAM users that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads.
     *
     * **Disclaimer**
     *
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.
     */
    public suspend fun deleteLens(input: DeleteLensRequest): DeleteLensResponse

    /**
     * Delete a lens share.
     *
     * After the lens share is deleted, Amazon Web Services accounts, IAM users, organizations, and organizational units (OUs) that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads.
     *
     * **Disclaimer**
     *
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.
     */
    public suspend fun deleteLensShare(input: DeleteLensShareRequest): DeleteLensShareResponse

    /**
     * Delete an existing workload.
     */
    public suspend fun deleteWorkload(input: DeleteWorkloadRequest): DeleteWorkloadResponse

    /**
     * Delete a workload share.
     */
    public suspend fun deleteWorkloadShare(input: DeleteWorkloadShareRequest): DeleteWorkloadShareResponse

    /**
     * Disassociate a lens from a workload.
     *
     * Up to 10 lenses can be disassociated from a workload in a single API operation.
     *
     * The Amazon Web Services Well-Architected Framework lens (`wellarchitected`) cannot be removed from a workload.
     */
    public suspend fun disassociateLenses(input: DisassociateLensesRequest): DisassociateLensesResponse

    /**
     * Export an existing lens.
     *
     * Lenses are defined in JSON. For more information, see [JSON format specification](https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html) in the *Well-Architected Tool User Guide*. Only the owner of a lens can export it.
     *
     * **Disclaimer**
     *
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     */
    public suspend fun exportLens(input: ExportLensRequest): ExportLensResponse

    /**
     * Get the answer to a specific question in a workload review.
     */
    public suspend fun getAnswer(input: GetAnswerRequest): GetAnswerResponse

    /**
     * Get an existing lens.
     */
    public suspend fun getLens(input: GetLensRequest): GetLensResponse

    /**
     * Get lens review.
     */
    public suspend fun getLensReview(input: GetLensReviewRequest): GetLensReviewResponse

    /**
     * Get lens review report.
     */
    public suspend fun getLensReviewReport(input: GetLensReviewReportRequest): GetLensReviewReportResponse

    /**
     * Get lens version differences.
     */
    public suspend fun getLensVersionDifference(input: GetLensVersionDifferenceRequest): GetLensVersionDifferenceResponse

    /**
     * Get a milestone for an existing workload.
     */
    public suspend fun getMilestone(input: GetMilestoneRequest): GetMilestoneResponse

    /**
     * Get an existing workload.
     */
    public suspend fun getWorkload(input: GetWorkloadRequest): GetWorkloadResponse

    /**
     * Import a new lens.
     *
     * The lens cannot be applied to workloads or shared with other Amazon Web Services accounts until it's published with CreateLensVersion
     *
     * Lenses are defined in JSON. For more information, see [JSON format specification](https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html) in the *Well-Architected Tool User Guide*.
     *
     * A custom lens cannot exceed 500 KB in size.
     *
     * **Disclaimer**
     *
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     */
    public suspend fun importLens(input: ImportLensRequest): ImportLensResponse

    /**
     * List of answers.
     */
    public suspend fun listAnswers(input: ListAnswersRequest): ListAnswersResponse

    /**
     * List of Trusted Advisor check details by account related to the workload.
     */
    public suspend fun listCheckDetails(input: ListCheckDetailsRequest): ListCheckDetailsResponse

    /**
     * List of Trusted Advisor checks summarized for all accounts related to the workload.
     */
    public suspend fun listCheckSummaries(input: ListCheckSummariesRequest): ListCheckSummariesResponse

    /**
     * List lens review improvements.
     */
    public suspend fun listLensReviewImprovements(input: ListLensReviewImprovementsRequest): ListLensReviewImprovementsResponse

    /**
     * List lens reviews.
     */
    public suspend fun listLensReviews(input: ListLensReviewsRequest): ListLensReviewsResponse

    /**
     * List the lens shares associated with the lens.
     */
    public suspend fun listLensShares(input: ListLensSharesRequest): ListLensSharesResponse

    /**
     * List the available lenses.
     */
    public suspend fun listLenses(input: ListLensesRequest = ListLensesRequest {}): ListLensesResponse

    /**
     * List all milestones for an existing workload.
     */
    public suspend fun listMilestones(input: ListMilestonesRequest): ListMilestonesResponse

    /**
     * List lens notifications.
     */
    public suspend fun listNotifications(input: ListNotificationsRequest = ListNotificationsRequest {}): ListNotificationsResponse

    /**
     * List the workload invitations.
     */
    public suspend fun listShareInvitations(input: ListShareInvitationsRequest = ListShareInvitationsRequest {}): ListShareInvitationsResponse

    /**
     * List the tags for a resource.
     *
     * The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * List the workload shares associated with the workload.
     */
    public suspend fun listWorkloadShares(input: ListWorkloadSharesRequest): ListWorkloadSharesResponse

    /**
     * List workloads. Paginated.
     */
    public suspend fun listWorkloads(input: ListWorkloadsRequest = ListWorkloadsRequest {}): ListWorkloadsResponse

    /**
     * Adds one or more tags to the specified resource.
     *
     * The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes specified tags from a resource.
     *
     * The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.
     *
     * To specify multiple tags, use separate **tagKeys** parameters, for example:
     *
     * `DELETE /tags/WorkloadArn?tagKeys=key1&tagKeys=key2`
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Update the answer to a specific question in a workload review.
     */
    public suspend fun updateAnswer(input: UpdateAnswerRequest): UpdateAnswerResponse

    /**
     * Updates whether the Amazon Web Services account is opted into organization sharing features.
     */
    public suspend fun updateGlobalSettings(input: UpdateGlobalSettingsRequest = UpdateGlobalSettingsRequest {}): UpdateGlobalSettingsResponse

    /**
     * Update lens review.
     */
    public suspend fun updateLensReview(input: UpdateLensReviewRequest): UpdateLensReviewResponse

    /**
     * Update a workload or custom lens share invitation.
     *
     * This API operation can be called independently of any resource. Previous documentation implied that a workload ARN must be specified.
     */
    public suspend fun updateShareInvitation(input: UpdateShareInvitationRequest): UpdateShareInvitationResponse

    /**
     * Update an existing workload.
     */
    public suspend fun updateWorkload(input: UpdateWorkloadRequest): UpdateWorkloadResponse

    /**
     * Update a workload share.
     */
    public suspend fun updateWorkloadShare(input: UpdateWorkloadShareRequest): UpdateWorkloadShareResponse

    /**
     * Upgrade lens review.
     */
    public suspend fun upgradeLensReview(input: UpgradeLensReviewRequest): UpgradeLensReviewResponse
}

/**
 * Associate a lens to a workload.
 *
 * Up to 10 lenses can be associated with a workload in a single API operation. A maximum of 20 lenses can be associated with a workload.
 *
 * **Disclaimer**
 *
 * By accessing and/or applying custom lenses created by another Amazon Web Services user or account, you acknowledge that custom lenses created by other users and shared with you are Third Party Content as defined in the Amazon Web Services Customer Agreement.
 */
public suspend inline fun WellArchitectedClient.associateLenses(crossinline block: AssociateLensesRequest.Builder.() -> Unit): AssociateLensesResponse = associateLenses(AssociateLensesRequest.Builder().apply(block).build())

/**
 * Create a lens share.
 *
 * The owner of a lens can share it with other Amazon Web Services accounts, IAM users, an organization, and organizational units (OUs) in the same Amazon Web Services Region. Shared access to a lens is not removed until the lens invitation is deleted.
 *
 * **Disclaimer**
 *
 * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.
 */
public suspend inline fun WellArchitectedClient.createLensShare(crossinline block: CreateLensShareRequest.Builder.() -> Unit): CreateLensShareResponse = createLensShare(CreateLensShareRequest.Builder().apply(block).build())

/**
 * Create a new lens version.
 *
 * A lens can have up to 100 versions.
 *
 * After a lens has been imported, create a new lens version to publish it. The owner of a lens can share the lens with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Only the owner of a lens can delete it.
 */
public suspend inline fun WellArchitectedClient.createLensVersion(crossinline block: CreateLensVersionRequest.Builder.() -> Unit): CreateLensVersionResponse = createLensVersion(CreateLensVersionRequest.Builder().apply(block).build())

/**
 * Create a milestone for an existing workload.
 */
public suspend inline fun WellArchitectedClient.createMilestone(crossinline block: CreateMilestoneRequest.Builder.() -> Unit): CreateMilestoneResponse = createMilestone(CreateMilestoneRequest.Builder().apply(block).build())

/**
 * Create a new workload.
 *
 * The owner of a workload can share the workload with other Amazon Web Services accounts, IAM users, an organization, and organizational units (OUs) in the same Amazon Web Services Region. Only the owner of a workload can delete it.
 *
 * For more information, see [Defining a Workload](https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html) in the *Well-Architected Tool User Guide*.
 */
public suspend inline fun WellArchitectedClient.createWorkload(crossinline block: CreateWorkloadRequest.Builder.() -> Unit): CreateWorkloadResponse = createWorkload(CreateWorkloadRequest.Builder().apply(block).build())

/**
 * Create a workload share.
 *
 * The owner of a workload can share it with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Shared access to a workload is not removed until the workload invitation is deleted.
 *
 * For more information, see [Sharing a Workload](https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html) in the *Well-Architected Tool User Guide*.
 */
public suspend inline fun WellArchitectedClient.createWorkloadShare(crossinline block: CreateWorkloadShareRequest.Builder.() -> Unit): CreateWorkloadShareResponse = createWorkloadShare(CreateWorkloadShareRequest.Builder().apply(block).build())

/**
 * Delete an existing lens.
 *
 * Only the owner of a lens can delete it. After the lens is deleted, Amazon Web Services accounts and IAM users that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads.
 *
 * **Disclaimer**
 *
 * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.
 */
public suspend inline fun WellArchitectedClient.deleteLens(crossinline block: DeleteLensRequest.Builder.() -> Unit): DeleteLensResponse = deleteLens(DeleteLensRequest.Builder().apply(block).build())

/**
 * Delete a lens share.
 *
 * After the lens share is deleted, Amazon Web Services accounts, IAM users, organizations, and organizational units (OUs) that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads.
 *
 * **Disclaimer**
 *
 * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.
 */
public suspend inline fun WellArchitectedClient.deleteLensShare(crossinline block: DeleteLensShareRequest.Builder.() -> Unit): DeleteLensShareResponse = deleteLensShare(DeleteLensShareRequest.Builder().apply(block).build())

/**
 * Delete an existing workload.
 */
public suspend inline fun WellArchitectedClient.deleteWorkload(crossinline block: DeleteWorkloadRequest.Builder.() -> Unit): DeleteWorkloadResponse = deleteWorkload(DeleteWorkloadRequest.Builder().apply(block).build())

/**
 * Delete a workload share.
 */
public suspend inline fun WellArchitectedClient.deleteWorkloadShare(crossinline block: DeleteWorkloadShareRequest.Builder.() -> Unit): DeleteWorkloadShareResponse = deleteWorkloadShare(DeleteWorkloadShareRequest.Builder().apply(block).build())

/**
 * Disassociate a lens from a workload.
 *
 * Up to 10 lenses can be disassociated from a workload in a single API operation.
 *
 * The Amazon Web Services Well-Architected Framework lens (`wellarchitected`) cannot be removed from a workload.
 */
public suspend inline fun WellArchitectedClient.disassociateLenses(crossinline block: DisassociateLensesRequest.Builder.() -> Unit): DisassociateLensesResponse = disassociateLenses(DisassociateLensesRequest.Builder().apply(block).build())

/**
 * Export an existing lens.
 *
 * Lenses are defined in JSON. For more information, see [JSON format specification](https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html) in the *Well-Architected Tool User Guide*. Only the owner of a lens can export it.
 *
 * **Disclaimer**
 *
 * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
 */
public suspend inline fun WellArchitectedClient.exportLens(crossinline block: ExportLensRequest.Builder.() -> Unit): ExportLensResponse = exportLens(ExportLensRequest.Builder().apply(block).build())

/**
 * Get the answer to a specific question in a workload review.
 */
public suspend inline fun WellArchitectedClient.getAnswer(crossinline block: GetAnswerRequest.Builder.() -> Unit): GetAnswerResponse = getAnswer(GetAnswerRequest.Builder().apply(block).build())

/**
 * Get an existing lens.
 */
public suspend inline fun WellArchitectedClient.getLens(crossinline block: GetLensRequest.Builder.() -> Unit): GetLensResponse = getLens(GetLensRequest.Builder().apply(block).build())

/**
 * Get lens review.
 */
public suspend inline fun WellArchitectedClient.getLensReview(crossinline block: GetLensReviewRequest.Builder.() -> Unit): GetLensReviewResponse = getLensReview(GetLensReviewRequest.Builder().apply(block).build())

/**
 * Get lens review report.
 */
public suspend inline fun WellArchitectedClient.getLensReviewReport(crossinline block: GetLensReviewReportRequest.Builder.() -> Unit): GetLensReviewReportResponse = getLensReviewReport(GetLensReviewReportRequest.Builder().apply(block).build())

/**
 * Get lens version differences.
 */
public suspend inline fun WellArchitectedClient.getLensVersionDifference(crossinline block: GetLensVersionDifferenceRequest.Builder.() -> Unit): GetLensVersionDifferenceResponse = getLensVersionDifference(GetLensVersionDifferenceRequest.Builder().apply(block).build())

/**
 * Get a milestone for an existing workload.
 */
public suspend inline fun WellArchitectedClient.getMilestone(crossinline block: GetMilestoneRequest.Builder.() -> Unit): GetMilestoneResponse = getMilestone(GetMilestoneRequest.Builder().apply(block).build())

/**
 * Get an existing workload.
 */
public suspend inline fun WellArchitectedClient.getWorkload(crossinline block: GetWorkloadRequest.Builder.() -> Unit): GetWorkloadResponse = getWorkload(GetWorkloadRequest.Builder().apply(block).build())

/**
 * Import a new lens.
 *
 * The lens cannot be applied to workloads or shared with other Amazon Web Services accounts until it's published with CreateLensVersion
 *
 * Lenses are defined in JSON. For more information, see [JSON format specification](https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html) in the *Well-Architected Tool User Guide*.
 *
 * A custom lens cannot exceed 500 KB in size.
 *
 * **Disclaimer**
 *
 * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
 */
public suspend inline fun WellArchitectedClient.importLens(crossinline block: ImportLensRequest.Builder.() -> Unit): ImportLensResponse = importLens(ImportLensRequest.Builder().apply(block).build())

/**
 * List of answers.
 */
public suspend inline fun WellArchitectedClient.listAnswers(crossinline block: ListAnswersRequest.Builder.() -> Unit): ListAnswersResponse = listAnswers(ListAnswersRequest.Builder().apply(block).build())

/**
 * List of Trusted Advisor check details by account related to the workload.
 */
public suspend inline fun WellArchitectedClient.listCheckDetails(crossinline block: ListCheckDetailsRequest.Builder.() -> Unit): ListCheckDetailsResponse = listCheckDetails(ListCheckDetailsRequest.Builder().apply(block).build())

/**
 * List of Trusted Advisor checks summarized for all accounts related to the workload.
 */
public suspend inline fun WellArchitectedClient.listCheckSummaries(crossinline block: ListCheckSummariesRequest.Builder.() -> Unit): ListCheckSummariesResponse = listCheckSummaries(ListCheckSummariesRequest.Builder().apply(block).build())

/**
 * List lens review improvements.
 */
public suspend inline fun WellArchitectedClient.listLensReviewImprovements(crossinline block: ListLensReviewImprovementsRequest.Builder.() -> Unit): ListLensReviewImprovementsResponse = listLensReviewImprovements(ListLensReviewImprovementsRequest.Builder().apply(block).build())

/**
 * List lens reviews.
 */
public suspend inline fun WellArchitectedClient.listLensReviews(crossinline block: ListLensReviewsRequest.Builder.() -> Unit): ListLensReviewsResponse = listLensReviews(ListLensReviewsRequest.Builder().apply(block).build())

/**
 * List the lens shares associated with the lens.
 */
public suspend inline fun WellArchitectedClient.listLensShares(crossinline block: ListLensSharesRequest.Builder.() -> Unit): ListLensSharesResponse = listLensShares(ListLensSharesRequest.Builder().apply(block).build())

/**
 * List the available lenses.
 */
public suspend inline fun WellArchitectedClient.listLenses(crossinline block: ListLensesRequest.Builder.() -> Unit): ListLensesResponse = listLenses(ListLensesRequest.Builder().apply(block).build())

/**
 * List all milestones for an existing workload.
 */
public suspend inline fun WellArchitectedClient.listMilestones(crossinline block: ListMilestonesRequest.Builder.() -> Unit): ListMilestonesResponse = listMilestones(ListMilestonesRequest.Builder().apply(block).build())

/**
 * List lens notifications.
 */
public suspend inline fun WellArchitectedClient.listNotifications(crossinline block: ListNotificationsRequest.Builder.() -> Unit): ListNotificationsResponse = listNotifications(ListNotificationsRequest.Builder().apply(block).build())

/**
 * List the workload invitations.
 */
public suspend inline fun WellArchitectedClient.listShareInvitations(crossinline block: ListShareInvitationsRequest.Builder.() -> Unit): ListShareInvitationsResponse = listShareInvitations(ListShareInvitationsRequest.Builder().apply(block).build())

/**
 * List the tags for a resource.
 *
 * The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.
 */
public suspend inline fun WellArchitectedClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * List the workload shares associated with the workload.
 */
public suspend inline fun WellArchitectedClient.listWorkloadShares(crossinline block: ListWorkloadSharesRequest.Builder.() -> Unit): ListWorkloadSharesResponse = listWorkloadShares(ListWorkloadSharesRequest.Builder().apply(block).build())

/**
 * List workloads. Paginated.
 */
public suspend inline fun WellArchitectedClient.listWorkloads(crossinline block: ListWorkloadsRequest.Builder.() -> Unit): ListWorkloadsResponse = listWorkloads(ListWorkloadsRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to the specified resource.
 *
 * The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.
 */
public suspend inline fun WellArchitectedClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes specified tags from a resource.
 *
 * The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.
 *
 * To specify multiple tags, use separate **tagKeys** parameters, for example:
 *
 * `DELETE /tags/WorkloadArn?tagKeys=key1&tagKeys=key2`
 */
public suspend inline fun WellArchitectedClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Update the answer to a specific question in a workload review.
 */
public suspend inline fun WellArchitectedClient.updateAnswer(crossinline block: UpdateAnswerRequest.Builder.() -> Unit): UpdateAnswerResponse = updateAnswer(UpdateAnswerRequest.Builder().apply(block).build())

/**
 * Updates whether the Amazon Web Services account is opted into organization sharing features.
 */
public suspend inline fun WellArchitectedClient.updateGlobalSettings(crossinline block: UpdateGlobalSettingsRequest.Builder.() -> Unit): UpdateGlobalSettingsResponse = updateGlobalSettings(UpdateGlobalSettingsRequest.Builder().apply(block).build())

/**
 * Update lens review.
 */
public suspend inline fun WellArchitectedClient.updateLensReview(crossinline block: UpdateLensReviewRequest.Builder.() -> Unit): UpdateLensReviewResponse = updateLensReview(UpdateLensReviewRequest.Builder().apply(block).build())

/**
 * Update a workload or custom lens share invitation.
 *
 * This API operation can be called independently of any resource. Previous documentation implied that a workload ARN must be specified.
 */
public suspend inline fun WellArchitectedClient.updateShareInvitation(crossinline block: UpdateShareInvitationRequest.Builder.() -> Unit): UpdateShareInvitationResponse = updateShareInvitation(UpdateShareInvitationRequest.Builder().apply(block).build())

/**
 * Update an existing workload.
 */
public suspend inline fun WellArchitectedClient.updateWorkload(crossinline block: UpdateWorkloadRequest.Builder.() -> Unit): UpdateWorkloadResponse = updateWorkload(UpdateWorkloadRequest.Builder().apply(block).build())

/**
 * Update a workload share.
 */
public suspend inline fun WellArchitectedClient.updateWorkloadShare(crossinline block: UpdateWorkloadShareRequest.Builder.() -> Unit): UpdateWorkloadShareResponse = updateWorkloadShare(UpdateWorkloadShareRequest.Builder().apply(block).build())

/**
 * Upgrade lens review.
 */
public suspend inline fun WellArchitectedClient.upgradeLensReview(crossinline block: UpgradeLensReviewRequest.Builder.() -> Unit): UpgradeLensReviewResponse = upgradeLensReview(UpgradeLensReviewRequest.Builder().apply(block).build())
