// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.serde

import aws.sdk.kotlin.services.wellarchitected.model.IntegratingService
import aws.sdk.kotlin.services.wellarchitected.model.UpdateIntegrationRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateIntegrationOperationSerializer: HttpSerializer.NonStreaming<UpdateIntegrationRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateIntegrationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.workloadId) { "workloadId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("workloads"))
                add(PercentEncoding.SmithyLabel.encode(input.workloadId))
                add(PercentEncoding.Path.encode("updateIntegration"))
            }
        }

        val payload = serializeUpdateIntegrationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateIntegrationOperationBody(context: ExecutionContext, input: UpdateIntegrationRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientRequestToken"))
    val INTEGRATINGSERVICE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("IntegratingService"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(INTEGRATINGSERVICE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.integratingService?.let { field(INTEGRATINGSERVICE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
