// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.wellarchitected.auth.DefaultWellArchitectedAuthSchemeProvider
import aws.sdk.kotlin.services.wellarchitected.auth.WellArchitectedAuthSchemeProvider
import aws.sdk.kotlin.services.wellarchitected.endpoints.DefaultWellArchitectedEndpointProvider
import aws.sdk.kotlin.services.wellarchitected.endpoints.WellArchitectedEndpointParameters
import aws.sdk.kotlin.services.wellarchitected.endpoints.WellArchitectedEndpointProvider
import aws.sdk.kotlin.services.wellarchitected.model.AssociateLensesRequest
import aws.sdk.kotlin.services.wellarchitected.model.AssociateLensesResponse
import aws.sdk.kotlin.services.wellarchitected.model.AssociateProfilesRequest
import aws.sdk.kotlin.services.wellarchitected.model.AssociateProfilesResponse
import aws.sdk.kotlin.services.wellarchitected.model.CreateLensShareRequest
import aws.sdk.kotlin.services.wellarchitected.model.CreateLensShareResponse
import aws.sdk.kotlin.services.wellarchitected.model.CreateLensVersionRequest
import aws.sdk.kotlin.services.wellarchitected.model.CreateLensVersionResponse
import aws.sdk.kotlin.services.wellarchitected.model.CreateMilestoneRequest
import aws.sdk.kotlin.services.wellarchitected.model.CreateMilestoneResponse
import aws.sdk.kotlin.services.wellarchitected.model.CreateProfileRequest
import aws.sdk.kotlin.services.wellarchitected.model.CreateProfileResponse
import aws.sdk.kotlin.services.wellarchitected.model.CreateProfileShareRequest
import aws.sdk.kotlin.services.wellarchitected.model.CreateProfileShareResponse
import aws.sdk.kotlin.services.wellarchitected.model.CreateReviewTemplateRequest
import aws.sdk.kotlin.services.wellarchitected.model.CreateReviewTemplateResponse
import aws.sdk.kotlin.services.wellarchitected.model.CreateTemplateShareRequest
import aws.sdk.kotlin.services.wellarchitected.model.CreateTemplateShareResponse
import aws.sdk.kotlin.services.wellarchitected.model.CreateWorkloadRequest
import aws.sdk.kotlin.services.wellarchitected.model.CreateWorkloadResponse
import aws.sdk.kotlin.services.wellarchitected.model.CreateWorkloadShareRequest
import aws.sdk.kotlin.services.wellarchitected.model.CreateWorkloadShareResponse
import aws.sdk.kotlin.services.wellarchitected.model.DeleteLensRequest
import aws.sdk.kotlin.services.wellarchitected.model.DeleteLensResponse
import aws.sdk.kotlin.services.wellarchitected.model.DeleteLensShareRequest
import aws.sdk.kotlin.services.wellarchitected.model.DeleteLensShareResponse
import aws.sdk.kotlin.services.wellarchitected.model.DeleteProfileRequest
import aws.sdk.kotlin.services.wellarchitected.model.DeleteProfileResponse
import aws.sdk.kotlin.services.wellarchitected.model.DeleteProfileShareRequest
import aws.sdk.kotlin.services.wellarchitected.model.DeleteProfileShareResponse
import aws.sdk.kotlin.services.wellarchitected.model.DeleteReviewTemplateRequest
import aws.sdk.kotlin.services.wellarchitected.model.DeleteReviewTemplateResponse
import aws.sdk.kotlin.services.wellarchitected.model.DeleteTemplateShareRequest
import aws.sdk.kotlin.services.wellarchitected.model.DeleteTemplateShareResponse
import aws.sdk.kotlin.services.wellarchitected.model.DeleteWorkloadRequest
import aws.sdk.kotlin.services.wellarchitected.model.DeleteWorkloadResponse
import aws.sdk.kotlin.services.wellarchitected.model.DeleteWorkloadShareRequest
import aws.sdk.kotlin.services.wellarchitected.model.DeleteWorkloadShareResponse
import aws.sdk.kotlin.services.wellarchitected.model.DisassociateLensesRequest
import aws.sdk.kotlin.services.wellarchitected.model.DisassociateLensesResponse
import aws.sdk.kotlin.services.wellarchitected.model.DisassociateProfilesRequest
import aws.sdk.kotlin.services.wellarchitected.model.DisassociateProfilesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ExportLensRequest
import aws.sdk.kotlin.services.wellarchitected.model.ExportLensResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetAnswerRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetAnswerResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetConsolidatedReportRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetConsolidatedReportResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetGlobalSettingsRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetGlobalSettingsResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetLensRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetLensResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetLensReviewReportRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetLensReviewReportResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetLensReviewRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetLensReviewResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetLensVersionDifferenceRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetLensVersionDifferenceResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetMilestoneRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetMilestoneResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetProfileRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetProfileResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetProfileTemplateRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetProfileTemplateResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetReviewTemplateAnswerRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetReviewTemplateAnswerResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetReviewTemplateLensReviewRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetReviewTemplateLensReviewResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetReviewTemplateRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetReviewTemplateResponse
import aws.sdk.kotlin.services.wellarchitected.model.GetWorkloadRequest
import aws.sdk.kotlin.services.wellarchitected.model.GetWorkloadResponse
import aws.sdk.kotlin.services.wellarchitected.model.ImportLensRequest
import aws.sdk.kotlin.services.wellarchitected.model.ImportLensResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListAnswersRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListAnswersResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListCheckDetailsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListCheckDetailsResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListCheckSummariesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListCheckSummariesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListLensReviewImprovementsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListLensReviewImprovementsResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListLensReviewsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListLensReviewsResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListLensSharesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListLensSharesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListLensesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListLensesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListMilestonesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListMilestonesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListNotificationsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListNotificationsResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListProfileNotificationsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListProfileNotificationsResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListProfileSharesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListProfileSharesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListProfilesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListProfilesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListReviewTemplateAnswersRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListReviewTemplateAnswersResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListReviewTemplatesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListReviewTemplatesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListShareInvitationsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListShareInvitationsResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListTemplateSharesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListTemplateSharesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListWorkloadSharesRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListWorkloadSharesResponse
import aws.sdk.kotlin.services.wellarchitected.model.ListWorkloadsRequest
import aws.sdk.kotlin.services.wellarchitected.model.ListWorkloadsResponse
import aws.sdk.kotlin.services.wellarchitected.model.TagResourceRequest
import aws.sdk.kotlin.services.wellarchitected.model.TagResourceResponse
import aws.sdk.kotlin.services.wellarchitected.model.UntagResourceRequest
import aws.sdk.kotlin.services.wellarchitected.model.UntagResourceResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateAnswerRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateAnswerResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateGlobalSettingsRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateGlobalSettingsResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateIntegrationRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateIntegrationResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateLensReviewRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateLensReviewResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateProfileRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateProfileResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateReviewTemplateAnswerRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateReviewTemplateAnswerResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateReviewTemplateLensReviewRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateReviewTemplateLensReviewResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateReviewTemplateRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateReviewTemplateResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateShareInvitationRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateShareInvitationResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateWorkloadRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateWorkloadResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpdateWorkloadShareRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpdateWorkloadShareResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpgradeLensReviewRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpgradeLensReviewResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpgradeProfileVersionRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpgradeProfileVersionResponse
import aws.sdk.kotlin.services.wellarchitected.model.UpgradeReviewTemplateLensReviewRequest
import aws.sdk.kotlin.services.wellarchitected.model.UpgradeReviewTemplateLensReviewResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "WellArchitected"
public const val SdkVersion: String = "1.5.9"
public const val ServiceApiVersion: String = "2020-03-31"

/**
 * # Well-Architected Tool
 * This is the *Well-Architected Tool API Reference*. The WA Tool API provides programmatic access to the [Well-Architected Tool](http://aws.amazon.com/well-architected-tool) in the [Amazon Web Services Management Console](https://console.aws.amazon.com/wellarchitected). For information about the Well-Architected Tool, see the [Well-Architected Tool User Guide](https://docs.aws.amazon.com/wellarchitected/latest/userguide/intro.html).
 */
public interface WellArchitectedClient : SdkClient {
    /**
     * WellArchitectedClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, WellArchitectedClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "WellArchitected",
                "WELLARCHITECTED",
                "wellarchitected",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, WellArchitectedClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): WellArchitectedClient = DefaultWellArchitectedClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: WellArchitectedEndpointProvider = builder.endpointProvider ?: DefaultWellArchitectedEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: WellArchitectedAuthSchemeProvider = builder.authSchemeProvider ?: DefaultWellArchitectedAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "WellArchitected"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: WellArchitectedEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: WellArchitectedAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associate a lens to a workload.
     *
     * Up to 10 lenses can be associated with a workload in a single API operation. A maximum of 20 lenses can be associated with a workload.
     *
     * **Disclaimer**
     *
     * By accessing and/or applying custom lenses created by another Amazon Web Services user or account, you acknowledge that custom lenses created by other users and shared with you are Third Party Content as defined in the Amazon Web Services Customer Agreement.
     */
    public suspend fun associateLenses(input: AssociateLensesRequest): AssociateLensesResponse

    /**
     * Associate a profile with a workload.
     */
    public suspend fun associateProfiles(input: AssociateProfilesRequest): AssociateProfilesResponse

    /**
     * Create a lens share.
     *
     * The owner of a lens can share it with other Amazon Web Services accounts, users, an organization, and organizational units (OUs) in the same Amazon Web Services Region. Lenses provided by Amazon Web Services (Amazon Web Services Official Content) cannot be shared.
     *
     *  Shared access to a lens is not removed until the lens invitation is deleted.
     *
     * If you share a lens with an organization or OU, all accounts in the organization or OU are granted access to the lens.
     *
     * For more information, see [Sharing a custom lens](https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-sharing.html) in the *Well-Architected Tool User Guide*.
     *
     * **Disclaimer**
     *
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.
     */
    public suspend fun createLensShare(input: CreateLensShareRequest): CreateLensShareResponse

    /**
     * Create a new lens version.
     *
     * A lens can have up to 100 versions.
     *
     * Use this operation to publish a new lens version after you have imported a lens. The `LensAlias` is used to identify the lens to be published. The owner of a lens can share the lens with other Amazon Web Services accounts and users in the same Amazon Web Services Region. Only the owner of a lens can delete it.
     */
    public suspend fun createLensVersion(input: CreateLensVersionRequest): CreateLensVersionResponse

    /**
     * Create a milestone for an existing workload.
     */
    public suspend fun createMilestone(input: CreateMilestoneRequest): CreateMilestoneResponse

    /**
     * Create a profile.
     */
    public suspend fun createProfile(input: CreateProfileRequest): CreateProfileResponse

    /**
     * Create a profile share.
     */
    public suspend fun createProfileShare(input: CreateProfileShareRequest): CreateProfileShareResponse

    /**
     * Create a review template.
     *
     * **Disclaimer**
     *
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your review templates. If your review template or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     */
    public suspend fun createReviewTemplate(input: CreateReviewTemplateRequest): CreateReviewTemplateResponse

    /**
     * Create a review template share.
     *
     * The owner of a review template can share it with other Amazon Web Services accounts, users, an organization, and organizational units (OUs) in the same Amazon Web Services Region.
     *
     *  Shared access to a review template is not removed until the review template share invitation is deleted.
     *
     * If you share a review template with an organization or OU, all accounts in the organization or OU are granted access to the review template.
     *
     * **Disclaimer**
     *
     * By sharing your review template with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your review template available to those other accounts.
     */
    public suspend fun createTemplateShare(input: CreateTemplateShareRequest): CreateTemplateShareResponse

    /**
     * Create a new workload.
     *
     * The owner of a workload can share the workload with other Amazon Web Services accounts, users, an organization, and organizational units (OUs) in the same Amazon Web Services Region. Only the owner of a workload can delete it.
     *
     * For more information, see [Defining a Workload](https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html) in the *Well-Architected Tool User Guide*.
     *
     * Either `AwsRegions`, `NonAwsRegions`, or both must be specified when creating a workload.
     *
     * You also must specify `ReviewOwner`, even though the parameter is listed as not being required in the following section.
     *
     * When creating a workload using a review template, you must have the following IAM permissions:
     * + `wellarchitected:GetReviewTemplate`
     * + `wellarchitected:GetReviewTemplateAnswer`
     * + `wellarchitected:ListReviewTemplateAnswers`
     * + `wellarchitected:GetReviewTemplateLensReview`
     */
    public suspend fun createWorkload(input: CreateWorkloadRequest): CreateWorkloadResponse

    /**
     * Create a workload share.
     *
     * The owner of a workload can share it with other Amazon Web Services accounts and users in the same Amazon Web Services Region. Shared access to a workload is not removed until the workload invitation is deleted.
     *
     * If you share a workload with an organization or OU, all accounts in the organization or OU are granted access to the workload.
     *
     * For more information, see [Sharing a workload](https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html) in the *Well-Architected Tool User Guide*.
     */
    public suspend fun createWorkloadShare(input: CreateWorkloadShareRequest): CreateWorkloadShareResponse

    /**
     * Delete an existing lens.
     *
     * Only the owner of a lens can delete it. After the lens is deleted, Amazon Web Services accounts and users that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads.
     *
     * **Disclaimer**
     *
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.
     */
    public suspend fun deleteLens(input: DeleteLensRequest): DeleteLensResponse

    /**
     * Delete a lens share.
     *
     * After the lens share is deleted, Amazon Web Services accounts, users, organizations, and organizational units (OUs) that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads.
     *
     * **Disclaimer**
     *
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.
     */
    public suspend fun deleteLensShare(input: DeleteLensShareRequest): DeleteLensShareResponse

    /**
     * Delete a profile.
     *
     * **Disclaimer**
     *
     * By sharing your profile with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your profile available to those other accounts. Those other accounts may continue to access and use your shared profile even if you delete the profile from your own Amazon Web Services account or terminate your Amazon Web Services account.
     */
    public suspend fun deleteProfile(input: DeleteProfileRequest): DeleteProfileResponse

    /**
     * Delete a profile share.
     */
    public suspend fun deleteProfileShare(input: DeleteProfileShareRequest): DeleteProfileShareResponse

    /**
     * Delete a review template.
     *
     * Only the owner of a review template can delete it.
     *
     * After the review template is deleted, Amazon Web Services accounts, users, organizations, and organizational units (OUs) that you shared the review template with will no longer be able to apply it to new workloads.
     */
    public suspend fun deleteReviewTemplate(input: DeleteReviewTemplateRequest): DeleteReviewTemplateResponse

    /**
     * Delete a review template share.
     *
     * After the review template share is deleted, Amazon Web Services accounts, users, organizations, and organizational units (OUs) that you shared the review template with will no longer be able to apply it to new workloads.
     */
    public suspend fun deleteTemplateShare(input: DeleteTemplateShareRequest): DeleteTemplateShareResponse

    /**
     * Delete an existing workload.
     */
    public suspend fun deleteWorkload(input: DeleteWorkloadRequest): DeleteWorkloadResponse

    /**
     * Delete a workload share.
     */
    public suspend fun deleteWorkloadShare(input: DeleteWorkloadShareRequest): DeleteWorkloadShareResponse

    /**
     * Disassociate a lens from a workload.
     *
     * Up to 10 lenses can be disassociated from a workload in a single API operation.
     *
     * The Amazon Web Services Well-Architected Framework lens (`wellarchitected`) cannot be removed from a workload.
     */
    public suspend fun disassociateLenses(input: DisassociateLensesRequest): DisassociateLensesResponse

    /**
     * Disassociate a profile from a workload.
     */
    public suspend fun disassociateProfiles(input: DisassociateProfilesRequest): DisassociateProfilesResponse

    /**
     * Export an existing lens.
     *
     * Only the owner of a lens can export it. Lenses provided by Amazon Web Services (Amazon Web Services Official Content) cannot be exported.
     *
     * Lenses are defined in JSON. For more information, see [JSON format specification](https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html) in the *Well-Architected Tool User Guide*.
     *
     * **Disclaimer**
     *
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     */
    public suspend fun exportLens(input: ExportLensRequest): ExportLensResponse

    /**
     * Get the answer to a specific question in a workload review.
     */
    public suspend fun getAnswer(input: GetAnswerRequest): GetAnswerResponse

    /**
     * Get a consolidated report of your workloads.
     *
     * You can optionally choose to include workloads that have been shared with you.
     */
    public suspend fun getConsolidatedReport(input: GetConsolidatedReportRequest): GetConsolidatedReportResponse

    /**
     * Global settings for all workloads.
     */
    public suspend fun getGlobalSettings(input: GetGlobalSettingsRequest = GetGlobalSettingsRequest { }): GetGlobalSettingsResponse

    /**
     * Get an existing lens.
     */
    public suspend fun getLens(input: GetLensRequest): GetLensResponse

    /**
     * Get lens review.
     */
    public suspend fun getLensReview(input: GetLensReviewRequest): GetLensReviewResponse

    /**
     * Get lens review report.
     */
    public suspend fun getLensReviewReport(input: GetLensReviewReportRequest): GetLensReviewReportResponse

    /**
     * Get lens version differences.
     */
    public suspend fun getLensVersionDifference(input: GetLensVersionDifferenceRequest): GetLensVersionDifferenceResponse

    /**
     * Get a milestone for an existing workload.
     */
    public suspend fun getMilestone(input: GetMilestoneRequest): GetMilestoneResponse

    /**
     * Get profile information.
     */
    public suspend fun getProfile(input: GetProfileRequest): GetProfileResponse

    /**
     * Get profile template.
     */
    public suspend fun getProfileTemplate(input: GetProfileTemplateRequest = GetProfileTemplateRequest { }): GetProfileTemplateResponse

    /**
     * Get review template.
     */
    public suspend fun getReviewTemplate(input: GetReviewTemplateRequest): GetReviewTemplateResponse

    /**
     * Get review template answer.
     */
    public suspend fun getReviewTemplateAnswer(input: GetReviewTemplateAnswerRequest): GetReviewTemplateAnswerResponse

    /**
     * Get a lens review associated with a review template.
     */
    public suspend fun getReviewTemplateLensReview(input: GetReviewTemplateLensReviewRequest): GetReviewTemplateLensReviewResponse

    /**
     * Get an existing workload.
     */
    public suspend fun getWorkload(input: GetWorkloadRequest): GetWorkloadResponse

    /**
     * Import a new custom lens or update an existing custom lens.
     *
     * To update an existing custom lens, specify its ARN as the `LensAlias`. If no ARN is specified, a new custom lens is created.
     *
     * The new or updated lens will have a status of `DRAFT`. The lens cannot be applied to workloads or shared with other Amazon Web Services accounts until it's published with CreateLensVersion.
     *
     * Lenses are defined in JSON. For more information, see [JSON format specification](https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html) in the *Well-Architected Tool User Guide*.
     *
     * A custom lens cannot exceed 500 KB in size.
     *
     * **Disclaimer**
     *
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     */
    public suspend fun importLens(input: ImportLensRequest): ImportLensResponse

    /**
     * List of answers for a particular workload and lens.
     */
    public suspend fun listAnswers(input: ListAnswersRequest): ListAnswersResponse

    /**
     * List of Trusted Advisor check details by account related to the workload.
     */
    public suspend fun listCheckDetails(input: ListCheckDetailsRequest): ListCheckDetailsResponse

    /**
     * List of Trusted Advisor checks summarized for all accounts related to the workload.
     */
    public suspend fun listCheckSummaries(input: ListCheckSummariesRequest): ListCheckSummariesResponse

    /**
     * List the improvements of a particular lens review.
     */
    public suspend fun listLensReviewImprovements(input: ListLensReviewImprovementsRequest): ListLensReviewImprovementsResponse

    /**
     * List lens reviews for a particular workload.
     */
    public suspend fun listLensReviews(input: ListLensReviewsRequest): ListLensReviewsResponse

    /**
     * List the lens shares associated with the lens.
     */
    public suspend fun listLensShares(input: ListLensSharesRequest): ListLensSharesResponse

    /**
     * List the available lenses.
     */
    public suspend fun listLenses(input: ListLensesRequest = ListLensesRequest { }): ListLensesResponse

    /**
     * List all milestones for an existing workload.
     */
    public suspend fun listMilestones(input: ListMilestonesRequest): ListMilestonesResponse

    /**
     * List lens notifications.
     */
    public suspend fun listNotifications(input: ListNotificationsRequest = ListNotificationsRequest { }): ListNotificationsResponse

    /**
     * List profile notifications.
     */
    public suspend fun listProfileNotifications(input: ListProfileNotificationsRequest = ListProfileNotificationsRequest { }): ListProfileNotificationsResponse

    /**
     * List profile shares.
     */
    public suspend fun listProfileShares(input: ListProfileSharesRequest): ListProfileSharesResponse

    /**
     * List profiles.
     */
    public suspend fun listProfiles(input: ListProfilesRequest = ListProfilesRequest { }): ListProfilesResponse

    /**
     * List the answers of a review template.
     */
    public suspend fun listReviewTemplateAnswers(input: ListReviewTemplateAnswersRequest): ListReviewTemplateAnswersResponse

    /**
     * List review templates.
     */
    public suspend fun listReviewTemplates(input: ListReviewTemplatesRequest = ListReviewTemplatesRequest { }): ListReviewTemplatesResponse

    /**
     * List the share invitations.
     *
     * `WorkloadNamePrefix`, `LensNamePrefix`, `ProfileNamePrefix`, and `TemplateNamePrefix` are mutually exclusive. Use the parameter that matches your `ShareResourceType`.
     */
    public suspend fun listShareInvitations(input: ListShareInvitationsRequest = ListShareInvitationsRequest { }): ListShareInvitationsResponse

    /**
     * List the tags for a resource.
     *
     * The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile ARN, or review template ARN.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * List review template shares.
     */
    public suspend fun listTemplateShares(input: ListTemplateSharesRequest): ListTemplateSharesResponse

    /**
     * List the workload shares associated with the workload.
     */
    public suspend fun listWorkloadShares(input: ListWorkloadSharesRequest): ListWorkloadSharesResponse

    /**
     * Paginated list of workloads.
     */
    public suspend fun listWorkloads(input: ListWorkloadsRequest = ListWorkloadsRequest { }): ListWorkloadsResponse

    /**
     * Adds one or more tags to the specified resource.
     *
     * The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile ARN, or review template ARN.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes specified tags from a resource.
     *
     * The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile ARN, or review template ARN.
     *
     * To specify multiple tags, use separate **tagKeys** parameters, for example:
     *
     * `DELETE /tags/WorkloadArn?tagKeys=key1&tagKeys=key2`
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Update the answer to a specific question in a workload review.
     */
    public suspend fun updateAnswer(input: UpdateAnswerRequest): UpdateAnswerResponse

    /**
     * Update whether the Amazon Web Services account is opted into organization sharing and discovery integration features.
     */
    public suspend fun updateGlobalSettings(input: UpdateGlobalSettingsRequest = UpdateGlobalSettingsRequest { }): UpdateGlobalSettingsResponse

    /**
     * Update integration features.
     */
    public suspend fun updateIntegration(input: UpdateIntegrationRequest): UpdateIntegrationResponse

    /**
     * Update lens review for a particular workload.
     */
    public suspend fun updateLensReview(input: UpdateLensReviewRequest): UpdateLensReviewResponse

    /**
     * Update a profile.
     */
    public suspend fun updateProfile(input: UpdateProfileRequest): UpdateProfileResponse

    /**
     * Update a review template.
     */
    public suspend fun updateReviewTemplate(input: UpdateReviewTemplateRequest): UpdateReviewTemplateResponse

    /**
     * Update a review template answer.
     */
    public suspend fun updateReviewTemplateAnswer(input: UpdateReviewTemplateAnswerRequest): UpdateReviewTemplateAnswerResponse

    /**
     * Update a lens review associated with a review template.
     */
    public suspend fun updateReviewTemplateLensReview(input: UpdateReviewTemplateLensReviewRequest): UpdateReviewTemplateLensReviewResponse

    /**
     * Update a workload or custom lens share invitation.
     *
     * This API operation can be called independently of any resource. Previous documentation implied that a workload ARN must be specified.
     */
    public suspend fun updateShareInvitation(input: UpdateShareInvitationRequest): UpdateShareInvitationResponse

    /**
     * Update an existing workload.
     */
    public suspend fun updateWorkload(input: UpdateWorkloadRequest): UpdateWorkloadResponse

    /**
     * Update a workload share.
     */
    public suspend fun updateWorkloadShare(input: UpdateWorkloadShareRequest): UpdateWorkloadShareResponse

    /**
     * Upgrade lens review for a particular workload.
     */
    public suspend fun upgradeLensReview(input: UpgradeLensReviewRequest): UpgradeLensReviewResponse

    /**
     * Upgrade a profile.
     */
    public suspend fun upgradeProfileVersion(input: UpgradeProfileVersionRequest): UpgradeProfileVersionResponse

    /**
     * Upgrade the lens review of a review template.
     */
    public suspend fun upgradeReviewTemplateLensReview(input: UpgradeReviewTemplateLensReviewRequest): UpgradeReviewTemplateLensReviewResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun WellArchitectedClient.withConfig(block: WellArchitectedClient.Config.Builder.() -> Unit): WellArchitectedClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultWellArchitectedClient(newConfig)
}

/**
 * Associate a lens to a workload.
 *
 * Up to 10 lenses can be associated with a workload in a single API operation. A maximum of 20 lenses can be associated with a workload.
 *
 * **Disclaimer**
 *
 * By accessing and/or applying custom lenses created by another Amazon Web Services user or account, you acknowledge that custom lenses created by other users and shared with you are Third Party Content as defined in the Amazon Web Services Customer Agreement.
 */
public suspend inline fun WellArchitectedClient.associateLenses(crossinline block: AssociateLensesRequest.Builder.() -> Unit): AssociateLensesResponse = associateLenses(AssociateLensesRequest.Builder().apply(block).build())

/**
 * Associate a profile with a workload.
 */
public suspend inline fun WellArchitectedClient.associateProfiles(crossinline block: AssociateProfilesRequest.Builder.() -> Unit): AssociateProfilesResponse = associateProfiles(AssociateProfilesRequest.Builder().apply(block).build())

/**
 * Create a lens share.
 *
 * The owner of a lens can share it with other Amazon Web Services accounts, users, an organization, and organizational units (OUs) in the same Amazon Web Services Region. Lenses provided by Amazon Web Services (Amazon Web Services Official Content) cannot be shared.
 *
 *  Shared access to a lens is not removed until the lens invitation is deleted.
 *
 * If you share a lens with an organization or OU, all accounts in the organization or OU are granted access to the lens.
 *
 * For more information, see [Sharing a custom lens](https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-sharing.html) in the *Well-Architected Tool User Guide*.
 *
 * **Disclaimer**
 *
 * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.
 */
public suspend inline fun WellArchitectedClient.createLensShare(crossinline block: CreateLensShareRequest.Builder.() -> Unit): CreateLensShareResponse = createLensShare(CreateLensShareRequest.Builder().apply(block).build())

/**
 * Create a new lens version.
 *
 * A lens can have up to 100 versions.
 *
 * Use this operation to publish a new lens version after you have imported a lens. The `LensAlias` is used to identify the lens to be published. The owner of a lens can share the lens with other Amazon Web Services accounts and users in the same Amazon Web Services Region. Only the owner of a lens can delete it.
 */
public suspend inline fun WellArchitectedClient.createLensVersion(crossinline block: CreateLensVersionRequest.Builder.() -> Unit): CreateLensVersionResponse = createLensVersion(CreateLensVersionRequest.Builder().apply(block).build())

/**
 * Create a milestone for an existing workload.
 */
public suspend inline fun WellArchitectedClient.createMilestone(crossinline block: CreateMilestoneRequest.Builder.() -> Unit): CreateMilestoneResponse = createMilestone(CreateMilestoneRequest.Builder().apply(block).build())

/**
 * Create a profile.
 */
public suspend inline fun WellArchitectedClient.createProfile(crossinline block: CreateProfileRequest.Builder.() -> Unit): CreateProfileResponse = createProfile(CreateProfileRequest.Builder().apply(block).build())

/**
 * Create a profile share.
 */
public suspend inline fun WellArchitectedClient.createProfileShare(crossinline block: CreateProfileShareRequest.Builder.() -> Unit): CreateProfileShareResponse = createProfileShare(CreateProfileShareRequest.Builder().apply(block).build())

/**
 * Create a review template.
 *
 * **Disclaimer**
 *
 * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your review templates. If your review template or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
 */
public suspend inline fun WellArchitectedClient.createReviewTemplate(crossinline block: CreateReviewTemplateRequest.Builder.() -> Unit): CreateReviewTemplateResponse = createReviewTemplate(CreateReviewTemplateRequest.Builder().apply(block).build())

/**
 * Create a review template share.
 *
 * The owner of a review template can share it with other Amazon Web Services accounts, users, an organization, and organizational units (OUs) in the same Amazon Web Services Region.
 *
 *  Shared access to a review template is not removed until the review template share invitation is deleted.
 *
 * If you share a review template with an organization or OU, all accounts in the organization or OU are granted access to the review template.
 *
 * **Disclaimer**
 *
 * By sharing your review template with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your review template available to those other accounts.
 */
public suspend inline fun WellArchitectedClient.createTemplateShare(crossinline block: CreateTemplateShareRequest.Builder.() -> Unit): CreateTemplateShareResponse = createTemplateShare(CreateTemplateShareRequest.Builder().apply(block).build())

/**
 * Create a new workload.
 *
 * The owner of a workload can share the workload with other Amazon Web Services accounts, users, an organization, and organizational units (OUs) in the same Amazon Web Services Region. Only the owner of a workload can delete it.
 *
 * For more information, see [Defining a Workload](https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html) in the *Well-Architected Tool User Guide*.
 *
 * Either `AwsRegions`, `NonAwsRegions`, or both must be specified when creating a workload.
 *
 * You also must specify `ReviewOwner`, even though the parameter is listed as not being required in the following section.
 *
 * When creating a workload using a review template, you must have the following IAM permissions:
 * + `wellarchitected:GetReviewTemplate`
 * + `wellarchitected:GetReviewTemplateAnswer`
 * + `wellarchitected:ListReviewTemplateAnswers`
 * + `wellarchitected:GetReviewTemplateLensReview`
 */
public suspend inline fun WellArchitectedClient.createWorkload(crossinline block: CreateWorkloadRequest.Builder.() -> Unit): CreateWorkloadResponse = createWorkload(CreateWorkloadRequest.Builder().apply(block).build())

/**
 * Create a workload share.
 *
 * The owner of a workload can share it with other Amazon Web Services accounts and users in the same Amazon Web Services Region. Shared access to a workload is not removed until the workload invitation is deleted.
 *
 * If you share a workload with an organization or OU, all accounts in the organization or OU are granted access to the workload.
 *
 * For more information, see [Sharing a workload](https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html) in the *Well-Architected Tool User Guide*.
 */
public suspend inline fun WellArchitectedClient.createWorkloadShare(crossinline block: CreateWorkloadShareRequest.Builder.() -> Unit): CreateWorkloadShareResponse = createWorkloadShare(CreateWorkloadShareRequest.Builder().apply(block).build())

/**
 * Delete an existing lens.
 *
 * Only the owner of a lens can delete it. After the lens is deleted, Amazon Web Services accounts and users that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads.
 *
 * **Disclaimer**
 *
 * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.
 */
public suspend inline fun WellArchitectedClient.deleteLens(crossinline block: DeleteLensRequest.Builder.() -> Unit): DeleteLensResponse = deleteLens(DeleteLensRequest.Builder().apply(block).build())

/**
 * Delete a lens share.
 *
 * After the lens share is deleted, Amazon Web Services accounts, users, organizations, and organizational units (OUs) that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads.
 *
 * **Disclaimer**
 *
 * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.
 */
public suspend inline fun WellArchitectedClient.deleteLensShare(crossinline block: DeleteLensShareRequest.Builder.() -> Unit): DeleteLensShareResponse = deleteLensShare(DeleteLensShareRequest.Builder().apply(block).build())

/**
 * Delete a profile.
 *
 * **Disclaimer**
 *
 * By sharing your profile with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your profile available to those other accounts. Those other accounts may continue to access and use your shared profile even if you delete the profile from your own Amazon Web Services account or terminate your Amazon Web Services account.
 */
public suspend inline fun WellArchitectedClient.deleteProfile(crossinline block: DeleteProfileRequest.Builder.() -> Unit): DeleteProfileResponse = deleteProfile(DeleteProfileRequest.Builder().apply(block).build())

/**
 * Delete a profile share.
 */
public suspend inline fun WellArchitectedClient.deleteProfileShare(crossinline block: DeleteProfileShareRequest.Builder.() -> Unit): DeleteProfileShareResponse = deleteProfileShare(DeleteProfileShareRequest.Builder().apply(block).build())

/**
 * Delete a review template.
 *
 * Only the owner of a review template can delete it.
 *
 * After the review template is deleted, Amazon Web Services accounts, users, organizations, and organizational units (OUs) that you shared the review template with will no longer be able to apply it to new workloads.
 */
public suspend inline fun WellArchitectedClient.deleteReviewTemplate(crossinline block: DeleteReviewTemplateRequest.Builder.() -> Unit): DeleteReviewTemplateResponse = deleteReviewTemplate(DeleteReviewTemplateRequest.Builder().apply(block).build())

/**
 * Delete a review template share.
 *
 * After the review template share is deleted, Amazon Web Services accounts, users, organizations, and organizational units (OUs) that you shared the review template with will no longer be able to apply it to new workloads.
 */
public suspend inline fun WellArchitectedClient.deleteTemplateShare(crossinline block: DeleteTemplateShareRequest.Builder.() -> Unit): DeleteTemplateShareResponse = deleteTemplateShare(DeleteTemplateShareRequest.Builder().apply(block).build())

/**
 * Delete an existing workload.
 */
public suspend inline fun WellArchitectedClient.deleteWorkload(crossinline block: DeleteWorkloadRequest.Builder.() -> Unit): DeleteWorkloadResponse = deleteWorkload(DeleteWorkloadRequest.Builder().apply(block).build())

/**
 * Delete a workload share.
 */
public suspend inline fun WellArchitectedClient.deleteWorkloadShare(crossinline block: DeleteWorkloadShareRequest.Builder.() -> Unit): DeleteWorkloadShareResponse = deleteWorkloadShare(DeleteWorkloadShareRequest.Builder().apply(block).build())

/**
 * Disassociate a lens from a workload.
 *
 * Up to 10 lenses can be disassociated from a workload in a single API operation.
 *
 * The Amazon Web Services Well-Architected Framework lens (`wellarchitected`) cannot be removed from a workload.
 */
public suspend inline fun WellArchitectedClient.disassociateLenses(crossinline block: DisassociateLensesRequest.Builder.() -> Unit): DisassociateLensesResponse = disassociateLenses(DisassociateLensesRequest.Builder().apply(block).build())

/**
 * Disassociate a profile from a workload.
 */
public suspend inline fun WellArchitectedClient.disassociateProfiles(crossinline block: DisassociateProfilesRequest.Builder.() -> Unit): DisassociateProfilesResponse = disassociateProfiles(DisassociateProfilesRequest.Builder().apply(block).build())

/**
 * Export an existing lens.
 *
 * Only the owner of a lens can export it. Lenses provided by Amazon Web Services (Amazon Web Services Official Content) cannot be exported.
 *
 * Lenses are defined in JSON. For more information, see [JSON format specification](https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html) in the *Well-Architected Tool User Guide*.
 *
 * **Disclaimer**
 *
 * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
 */
public suspend inline fun WellArchitectedClient.exportLens(crossinline block: ExportLensRequest.Builder.() -> Unit): ExportLensResponse = exportLens(ExportLensRequest.Builder().apply(block).build())

/**
 * Get the answer to a specific question in a workload review.
 */
public suspend inline fun WellArchitectedClient.getAnswer(crossinline block: GetAnswerRequest.Builder.() -> Unit): GetAnswerResponse = getAnswer(GetAnswerRequest.Builder().apply(block).build())

/**
 * Get a consolidated report of your workloads.
 *
 * You can optionally choose to include workloads that have been shared with you.
 */
public suspend inline fun WellArchitectedClient.getConsolidatedReport(crossinline block: GetConsolidatedReportRequest.Builder.() -> Unit): GetConsolidatedReportResponse = getConsolidatedReport(GetConsolidatedReportRequest.Builder().apply(block).build())

/**
 * Global settings for all workloads.
 */
public suspend inline fun WellArchitectedClient.getGlobalSettings(crossinline block: GetGlobalSettingsRequest.Builder.() -> Unit): GetGlobalSettingsResponse = getGlobalSettings(GetGlobalSettingsRequest.Builder().apply(block).build())

/**
 * Get an existing lens.
 */
public suspend inline fun WellArchitectedClient.getLens(crossinline block: GetLensRequest.Builder.() -> Unit): GetLensResponse = getLens(GetLensRequest.Builder().apply(block).build())

/**
 * Get lens review.
 */
public suspend inline fun WellArchitectedClient.getLensReview(crossinline block: GetLensReviewRequest.Builder.() -> Unit): GetLensReviewResponse = getLensReview(GetLensReviewRequest.Builder().apply(block).build())

/**
 * Get lens review report.
 */
public suspend inline fun WellArchitectedClient.getLensReviewReport(crossinline block: GetLensReviewReportRequest.Builder.() -> Unit): GetLensReviewReportResponse = getLensReviewReport(GetLensReviewReportRequest.Builder().apply(block).build())

/**
 * Get lens version differences.
 */
public suspend inline fun WellArchitectedClient.getLensVersionDifference(crossinline block: GetLensVersionDifferenceRequest.Builder.() -> Unit): GetLensVersionDifferenceResponse = getLensVersionDifference(GetLensVersionDifferenceRequest.Builder().apply(block).build())

/**
 * Get a milestone for an existing workload.
 */
public suspend inline fun WellArchitectedClient.getMilestone(crossinline block: GetMilestoneRequest.Builder.() -> Unit): GetMilestoneResponse = getMilestone(GetMilestoneRequest.Builder().apply(block).build())

/**
 * Get profile information.
 */
public suspend inline fun WellArchitectedClient.getProfile(crossinline block: GetProfileRequest.Builder.() -> Unit): GetProfileResponse = getProfile(GetProfileRequest.Builder().apply(block).build())

/**
 * Get profile template.
 */
public suspend inline fun WellArchitectedClient.getProfileTemplate(crossinline block: GetProfileTemplateRequest.Builder.() -> Unit): GetProfileTemplateResponse = getProfileTemplate(GetProfileTemplateRequest.Builder().apply(block).build())

/**
 * Get review template.
 */
public suspend inline fun WellArchitectedClient.getReviewTemplate(crossinline block: GetReviewTemplateRequest.Builder.() -> Unit): GetReviewTemplateResponse = getReviewTemplate(GetReviewTemplateRequest.Builder().apply(block).build())

/**
 * Get review template answer.
 */
public suspend inline fun WellArchitectedClient.getReviewTemplateAnswer(crossinline block: GetReviewTemplateAnswerRequest.Builder.() -> Unit): GetReviewTemplateAnswerResponse = getReviewTemplateAnswer(GetReviewTemplateAnswerRequest.Builder().apply(block).build())

/**
 * Get a lens review associated with a review template.
 */
public suspend inline fun WellArchitectedClient.getReviewTemplateLensReview(crossinline block: GetReviewTemplateLensReviewRequest.Builder.() -> Unit): GetReviewTemplateLensReviewResponse = getReviewTemplateLensReview(GetReviewTemplateLensReviewRequest.Builder().apply(block).build())

/**
 * Get an existing workload.
 */
public suspend inline fun WellArchitectedClient.getWorkload(crossinline block: GetWorkloadRequest.Builder.() -> Unit): GetWorkloadResponse = getWorkload(GetWorkloadRequest.Builder().apply(block).build())

/**
 * Import a new custom lens or update an existing custom lens.
 *
 * To update an existing custom lens, specify its ARN as the `LensAlias`. If no ARN is specified, a new custom lens is created.
 *
 * The new or updated lens will have a status of `DRAFT`. The lens cannot be applied to workloads or shared with other Amazon Web Services accounts until it's published with CreateLensVersion.
 *
 * Lenses are defined in JSON. For more information, see [JSON format specification](https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html) in the *Well-Architected Tool User Guide*.
 *
 * A custom lens cannot exceed 500 KB in size.
 *
 * **Disclaimer**
 *
 * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
 */
public suspend inline fun WellArchitectedClient.importLens(crossinline block: ImportLensRequest.Builder.() -> Unit): ImportLensResponse = importLens(ImportLensRequest.Builder().apply(block).build())

/**
 * List of answers for a particular workload and lens.
 */
public suspend inline fun WellArchitectedClient.listAnswers(crossinline block: ListAnswersRequest.Builder.() -> Unit): ListAnswersResponse = listAnswers(ListAnswersRequest.Builder().apply(block).build())

/**
 * List of Trusted Advisor check details by account related to the workload.
 */
public suspend inline fun WellArchitectedClient.listCheckDetails(crossinline block: ListCheckDetailsRequest.Builder.() -> Unit): ListCheckDetailsResponse = listCheckDetails(ListCheckDetailsRequest.Builder().apply(block).build())

/**
 * List of Trusted Advisor checks summarized for all accounts related to the workload.
 */
public suspend inline fun WellArchitectedClient.listCheckSummaries(crossinline block: ListCheckSummariesRequest.Builder.() -> Unit): ListCheckSummariesResponse = listCheckSummaries(ListCheckSummariesRequest.Builder().apply(block).build())

/**
 * List the improvements of a particular lens review.
 */
public suspend inline fun WellArchitectedClient.listLensReviewImprovements(crossinline block: ListLensReviewImprovementsRequest.Builder.() -> Unit): ListLensReviewImprovementsResponse = listLensReviewImprovements(ListLensReviewImprovementsRequest.Builder().apply(block).build())

/**
 * List lens reviews for a particular workload.
 */
public suspend inline fun WellArchitectedClient.listLensReviews(crossinline block: ListLensReviewsRequest.Builder.() -> Unit): ListLensReviewsResponse = listLensReviews(ListLensReviewsRequest.Builder().apply(block).build())

/**
 * List the lens shares associated with the lens.
 */
public suspend inline fun WellArchitectedClient.listLensShares(crossinline block: ListLensSharesRequest.Builder.() -> Unit): ListLensSharesResponse = listLensShares(ListLensSharesRequest.Builder().apply(block).build())

/**
 * List the available lenses.
 */
public suspend inline fun WellArchitectedClient.listLenses(crossinline block: ListLensesRequest.Builder.() -> Unit): ListLensesResponse = listLenses(ListLensesRequest.Builder().apply(block).build())

/**
 * List all milestones for an existing workload.
 */
public suspend inline fun WellArchitectedClient.listMilestones(crossinline block: ListMilestonesRequest.Builder.() -> Unit): ListMilestonesResponse = listMilestones(ListMilestonesRequest.Builder().apply(block).build())

/**
 * List lens notifications.
 */
public suspend inline fun WellArchitectedClient.listNotifications(crossinline block: ListNotificationsRequest.Builder.() -> Unit): ListNotificationsResponse = listNotifications(ListNotificationsRequest.Builder().apply(block).build())

/**
 * List profile notifications.
 */
public suspend inline fun WellArchitectedClient.listProfileNotifications(crossinline block: ListProfileNotificationsRequest.Builder.() -> Unit): ListProfileNotificationsResponse = listProfileNotifications(ListProfileNotificationsRequest.Builder().apply(block).build())

/**
 * List profile shares.
 */
public suspend inline fun WellArchitectedClient.listProfileShares(crossinline block: ListProfileSharesRequest.Builder.() -> Unit): ListProfileSharesResponse = listProfileShares(ListProfileSharesRequest.Builder().apply(block).build())

/**
 * List profiles.
 */
public suspend inline fun WellArchitectedClient.listProfiles(crossinline block: ListProfilesRequest.Builder.() -> Unit): ListProfilesResponse = listProfiles(ListProfilesRequest.Builder().apply(block).build())

/**
 * List the answers of a review template.
 */
public suspend inline fun WellArchitectedClient.listReviewTemplateAnswers(crossinline block: ListReviewTemplateAnswersRequest.Builder.() -> Unit): ListReviewTemplateAnswersResponse = listReviewTemplateAnswers(ListReviewTemplateAnswersRequest.Builder().apply(block).build())

/**
 * List review templates.
 */
public suspend inline fun WellArchitectedClient.listReviewTemplates(crossinline block: ListReviewTemplatesRequest.Builder.() -> Unit): ListReviewTemplatesResponse = listReviewTemplates(ListReviewTemplatesRequest.Builder().apply(block).build())

/**
 * List the share invitations.
 *
 * `WorkloadNamePrefix`, `LensNamePrefix`, `ProfileNamePrefix`, and `TemplateNamePrefix` are mutually exclusive. Use the parameter that matches your `ShareResourceType`.
 */
public suspend inline fun WellArchitectedClient.listShareInvitations(crossinline block: ListShareInvitationsRequest.Builder.() -> Unit): ListShareInvitationsResponse = listShareInvitations(ListShareInvitationsRequest.Builder().apply(block).build())

/**
 * List the tags for a resource.
 *
 * The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile ARN, or review template ARN.
 */
public suspend inline fun WellArchitectedClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * List review template shares.
 */
public suspend inline fun WellArchitectedClient.listTemplateShares(crossinline block: ListTemplateSharesRequest.Builder.() -> Unit): ListTemplateSharesResponse = listTemplateShares(ListTemplateSharesRequest.Builder().apply(block).build())

/**
 * List the workload shares associated with the workload.
 */
public suspend inline fun WellArchitectedClient.listWorkloadShares(crossinline block: ListWorkloadSharesRequest.Builder.() -> Unit): ListWorkloadSharesResponse = listWorkloadShares(ListWorkloadSharesRequest.Builder().apply(block).build())

/**
 * Paginated list of workloads.
 */
public suspend inline fun WellArchitectedClient.listWorkloads(crossinline block: ListWorkloadsRequest.Builder.() -> Unit): ListWorkloadsResponse = listWorkloads(ListWorkloadsRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to the specified resource.
 *
 * The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile ARN, or review template ARN.
 */
public suspend inline fun WellArchitectedClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes specified tags from a resource.
 *
 * The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile ARN, or review template ARN.
 *
 * To specify multiple tags, use separate **tagKeys** parameters, for example:
 *
 * `DELETE /tags/WorkloadArn?tagKeys=key1&tagKeys=key2`
 */
public suspend inline fun WellArchitectedClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Update the answer to a specific question in a workload review.
 */
public suspend inline fun WellArchitectedClient.updateAnswer(crossinline block: UpdateAnswerRequest.Builder.() -> Unit): UpdateAnswerResponse = updateAnswer(UpdateAnswerRequest.Builder().apply(block).build())

/**
 * Update whether the Amazon Web Services account is opted into organization sharing and discovery integration features.
 */
public suspend inline fun WellArchitectedClient.updateGlobalSettings(crossinline block: UpdateGlobalSettingsRequest.Builder.() -> Unit): UpdateGlobalSettingsResponse = updateGlobalSettings(UpdateGlobalSettingsRequest.Builder().apply(block).build())

/**
 * Update integration features.
 */
public suspend inline fun WellArchitectedClient.updateIntegration(crossinline block: UpdateIntegrationRequest.Builder.() -> Unit): UpdateIntegrationResponse = updateIntegration(UpdateIntegrationRequest.Builder().apply(block).build())

/**
 * Update lens review for a particular workload.
 */
public suspend inline fun WellArchitectedClient.updateLensReview(crossinline block: UpdateLensReviewRequest.Builder.() -> Unit): UpdateLensReviewResponse = updateLensReview(UpdateLensReviewRequest.Builder().apply(block).build())

/**
 * Update a profile.
 */
public suspend inline fun WellArchitectedClient.updateProfile(crossinline block: UpdateProfileRequest.Builder.() -> Unit): UpdateProfileResponse = updateProfile(UpdateProfileRequest.Builder().apply(block).build())

/**
 * Update a review template.
 */
public suspend inline fun WellArchitectedClient.updateReviewTemplate(crossinline block: UpdateReviewTemplateRequest.Builder.() -> Unit): UpdateReviewTemplateResponse = updateReviewTemplate(UpdateReviewTemplateRequest.Builder().apply(block).build())

/**
 * Update a review template answer.
 */
public suspend inline fun WellArchitectedClient.updateReviewTemplateAnswer(crossinline block: UpdateReviewTemplateAnswerRequest.Builder.() -> Unit): UpdateReviewTemplateAnswerResponse = updateReviewTemplateAnswer(UpdateReviewTemplateAnswerRequest.Builder().apply(block).build())

/**
 * Update a lens review associated with a review template.
 */
public suspend inline fun WellArchitectedClient.updateReviewTemplateLensReview(crossinline block: UpdateReviewTemplateLensReviewRequest.Builder.() -> Unit): UpdateReviewTemplateLensReviewResponse = updateReviewTemplateLensReview(UpdateReviewTemplateLensReviewRequest.Builder().apply(block).build())

/**
 * Update a workload or custom lens share invitation.
 *
 * This API operation can be called independently of any resource. Previous documentation implied that a workload ARN must be specified.
 */
public suspend inline fun WellArchitectedClient.updateShareInvitation(crossinline block: UpdateShareInvitationRequest.Builder.() -> Unit): UpdateShareInvitationResponse = updateShareInvitation(UpdateShareInvitationRequest.Builder().apply(block).build())

/**
 * Update an existing workload.
 */
public suspend inline fun WellArchitectedClient.updateWorkload(crossinline block: UpdateWorkloadRequest.Builder.() -> Unit): UpdateWorkloadResponse = updateWorkload(UpdateWorkloadRequest.Builder().apply(block).build())

/**
 * Update a workload share.
 */
public suspend inline fun WellArchitectedClient.updateWorkloadShare(crossinline block: UpdateWorkloadShareRequest.Builder.() -> Unit): UpdateWorkloadShareResponse = updateWorkloadShare(UpdateWorkloadShareRequest.Builder().apply(block).build())

/**
 * Upgrade lens review for a particular workload.
 */
public suspend inline fun WellArchitectedClient.upgradeLensReview(crossinline block: UpgradeLensReviewRequest.Builder.() -> Unit): UpgradeLensReviewResponse = upgradeLensReview(UpgradeLensReviewRequest.Builder().apply(block).build())

/**
 * Upgrade a profile.
 */
public suspend inline fun WellArchitectedClient.upgradeProfileVersion(crossinline block: UpgradeProfileVersionRequest.Builder.() -> Unit): UpgradeProfileVersionResponse = upgradeProfileVersion(UpgradeProfileVersionRequest.Builder().apply(block).build())

/**
 * Upgrade the lens review of a review template.
 */
public suspend inline fun WellArchitectedClient.upgradeReviewTemplateLensReview(crossinline block: UpgradeReviewTemplateLensReviewRequest.Builder.() -> Unit): UpgradeReviewTemplateLensReviewResponse = upgradeReviewTemplateLensReview(UpgradeReviewTemplateLensReviewRequest.Builder().apply(block).build())
