// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The lens review of a review template.
 */
public class ReviewTemplateLensReview private constructor(builder: Builder) {
    /**
     * The alias of the lens.
     *
     * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-east-1::lens/serverless`. Note that some operations (such as ExportLens and CreateLensShare) are not permitted on Amazon Web Services official lenses.
     *
     * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef`.
     *
     * Each lens is identified by its LensSummary$LensAlias.
     */
    public val lensAlias: kotlin.String? = builder.lensAlias
    /**
     * The lens ARN.
     */
    public val lensArn: kotlin.String? = builder.lensArn
    /**
     * The full name of the lens.
     */
    public val lensName: kotlin.String? = builder.lensName
    /**
     * The status of the lens.
     */
    public val lensStatus: aws.sdk.kotlin.services.wellarchitected.model.LensStatus? = builder.lensStatus
    /**
     * The version of the lens.
     */
    public val lensVersion: kotlin.String? = builder.lensVersion
    /**
     * The token to use to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The notes associated with the workload.
     *
     * For a review template, these are the notes that will be associated with the workload when the template is applied.
     */
    public val notes: kotlin.String? = builder.notes
    /**
     * Pillar review summaries of a lens review.
     */
    public val pillarReviewSummaries: List<ReviewTemplatePillarReviewSummary>? = builder.pillarReviewSummaries
    /**
     * A count of how many questions are answered and unanswered in the lens review.
     */
    public val questionCounts: Map<Question, Int>? = builder.questionCounts
    /**
     * The date and time recorded.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wellarchitected.model.ReviewTemplateLensReview = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReviewTemplateLensReview(")
        append("lensAlias=$lensAlias,")
        append("lensArn=$lensArn,")
        append("lensName=$lensName,")
        append("lensStatus=$lensStatus,")
        append("lensVersion=$lensVersion,")
        append("nextToken=$nextToken,")
        append("notes=$notes,")
        append("pillarReviewSummaries=$pillarReviewSummaries,")
        append("questionCounts=$questionCounts,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lensAlias?.hashCode() ?: 0
        result = 31 * result + (lensArn?.hashCode() ?: 0)
        result = 31 * result + (lensName?.hashCode() ?: 0)
        result = 31 * result + (lensStatus?.hashCode() ?: 0)
        result = 31 * result + (lensVersion?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (notes?.hashCode() ?: 0)
        result = 31 * result + (pillarReviewSummaries?.hashCode() ?: 0)
        result = 31 * result + (questionCounts?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReviewTemplateLensReview

        if (lensAlias != other.lensAlias) return false
        if (lensArn != other.lensArn) return false
        if (lensName != other.lensName) return false
        if (lensStatus != other.lensStatus) return false
        if (lensVersion != other.lensVersion) return false
        if (nextToken != other.nextToken) return false
        if (notes != other.notes) return false
        if (pillarReviewSummaries != other.pillarReviewSummaries) return false
        if (questionCounts != other.questionCounts) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wellarchitected.model.ReviewTemplateLensReview = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The alias of the lens.
         *
         * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-east-1::lens/serverless`. Note that some operations (such as ExportLens and CreateLensShare) are not permitted on Amazon Web Services official lenses.
         *
         * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef`.
         *
         * Each lens is identified by its LensSummary$LensAlias.
         */
        public var lensAlias: kotlin.String? = null
        /**
         * The lens ARN.
         */
        public var lensArn: kotlin.String? = null
        /**
         * The full name of the lens.
         */
        public var lensName: kotlin.String? = null
        /**
         * The status of the lens.
         */
        public var lensStatus: aws.sdk.kotlin.services.wellarchitected.model.LensStatus? = null
        /**
         * The version of the lens.
         */
        public var lensVersion: kotlin.String? = null
        /**
         * The token to use to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The notes associated with the workload.
         *
         * For a review template, these are the notes that will be associated with the workload when the template is applied.
         */
        public var notes: kotlin.String? = null
        /**
         * Pillar review summaries of a lens review.
         */
        public var pillarReviewSummaries: List<ReviewTemplatePillarReviewSummary>? = null
        /**
         * A count of how many questions are answered and unanswered in the lens review.
         */
        public var questionCounts: Map<Question, Int>? = null
        /**
         * The date and time recorded.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wellarchitected.model.ReviewTemplateLensReview) : this() {
            this.lensAlias = x.lensAlias
            this.lensArn = x.lensArn
            this.lensName = x.lensName
            this.lensStatus = x.lensStatus
            this.lensVersion = x.lensVersion
            this.nextToken = x.nextToken
            this.notes = x.notes
            this.pillarReviewSummaries = x.pillarReviewSummaries
            this.questionCounts = x.questionCounts
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wellarchitected.model.ReviewTemplateLensReview = ReviewTemplateLensReview(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
