// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A lens review summary of a workload.
 */
public class LensReviewSummary private constructor(builder: Builder) {
    /**
     * The alias of the lens.
     *
     * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-east-1::lens/serverless`. Note that some operations (such as ExportLens and CreateLensShare) are not permitted on Amazon Web Services official lenses.
     *
     * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef`.
     *
     * Each lens is identified by its LensSummary$LensAlias.
     */
    public val lensAlias: kotlin.String? = builder.lensAlias
    /**
     * The ARN for the lens.
     */
    public val lensArn: kotlin.String? = builder.lensArn
    /**
     * The full name of the lens.
     */
    public val lensName: kotlin.String? = builder.lensName
    /**
     * The status of the lens.
     */
    public val lensStatus: aws.sdk.kotlin.services.wellarchitected.model.LensStatus? = builder.lensStatus
    /**
     * The version of the lens.
     */
    public val lensVersion: kotlin.String? = builder.lensVersion
    /**
     * A map from risk names to the count of how many questions have that rating.
     */
    public val prioritizedRiskCounts: Map<Risk, Int>? = builder.prioritizedRiskCounts
    /**
     * The profiles associated with the workload.
     */
    public val profiles: List<WorkloadProfile>? = builder.profiles
    /**
     * A map from risk names to the count of how many questions have that rating.
     */
    public val riskCounts: Map<Risk, Int>? = builder.riskCounts
    /**
     * The date and time recorded.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wellarchitected.model.LensReviewSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LensReviewSummary(")
        append("lensAlias=$lensAlias,")
        append("lensArn=$lensArn,")
        append("lensName=$lensName,")
        append("lensStatus=$lensStatus,")
        append("lensVersion=$lensVersion,")
        append("prioritizedRiskCounts=$prioritizedRiskCounts,")
        append("profiles=$profiles,")
        append("riskCounts=$riskCounts,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lensAlias?.hashCode() ?: 0
        result = 31 * result + (lensArn?.hashCode() ?: 0)
        result = 31 * result + (lensName?.hashCode() ?: 0)
        result = 31 * result + (lensStatus?.hashCode() ?: 0)
        result = 31 * result + (lensVersion?.hashCode() ?: 0)
        result = 31 * result + (prioritizedRiskCounts?.hashCode() ?: 0)
        result = 31 * result + (profiles?.hashCode() ?: 0)
        result = 31 * result + (riskCounts?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LensReviewSummary

        if (lensAlias != other.lensAlias) return false
        if (lensArn != other.lensArn) return false
        if (lensName != other.lensName) return false
        if (lensStatus != other.lensStatus) return false
        if (lensVersion != other.lensVersion) return false
        if (prioritizedRiskCounts != other.prioritizedRiskCounts) return false
        if (profiles != other.profiles) return false
        if (riskCounts != other.riskCounts) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wellarchitected.model.LensReviewSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The alias of the lens.
         *
         * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-east-1::lens/serverless`. Note that some operations (such as ExportLens and CreateLensShare) are not permitted on Amazon Web Services official lenses.
         *
         * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef`.
         *
         * Each lens is identified by its LensSummary$LensAlias.
         */
        public var lensAlias: kotlin.String? = null
        /**
         * The ARN for the lens.
         */
        public var lensArn: kotlin.String? = null
        /**
         * The full name of the lens.
         */
        public var lensName: kotlin.String? = null
        /**
         * The status of the lens.
         */
        public var lensStatus: aws.sdk.kotlin.services.wellarchitected.model.LensStatus? = null
        /**
         * The version of the lens.
         */
        public var lensVersion: kotlin.String? = null
        /**
         * A map from risk names to the count of how many questions have that rating.
         */
        public var prioritizedRiskCounts: Map<Risk, Int>? = null
        /**
         * The profiles associated with the workload.
         */
        public var profiles: List<WorkloadProfile>? = null
        /**
         * A map from risk names to the count of how many questions have that rating.
         */
        public var riskCounts: Map<Risk, Int>? = null
        /**
         * The date and time recorded.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wellarchitected.model.LensReviewSummary) : this() {
            this.lensAlias = x.lensAlias
            this.lensArn = x.lensArn
            this.lensName = x.lensName
            this.lensStatus = x.lensStatus
            this.lensVersion = x.lensVersion
            this.prioritizedRiskCounts = x.prioritizedRiskCounts
            this.profiles = x.profiles
            this.riskCounts = x.riskCounts
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wellarchitected.model.LensReviewSummary = LensReviewSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
