// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A metric that contributes to the consolidated report.
 */
public class ConsolidatedReportMetric private constructor(builder: Builder) {
    /**
     * The metrics for the lenses in the workload.
     */
    public val lenses: List<LensMetric>? = builder.lenses
    /**
     * The total number of lenses applied to the workload.
     */
    public val lensesAppliedCount: kotlin.Int? = builder.lensesAppliedCount
    /**
     * The metric type of a metric in the consolidated report. Currently only WORKLOAD metric types are supported.
     */
    public val metricType: aws.sdk.kotlin.services.wellarchitected.model.MetricType? = builder.metricType
    /**
     * A map from risk names to the count of how many questions have that rating.
     */
    public val riskCounts: Map<Risk, Int>? = builder.riskCounts
    /**
     * The date and time recorded.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt
    /**
     * The ARN for the workload.
     */
    public val workloadArn: kotlin.String? = builder.workloadArn
    /**
     * The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.
     */
    public val workloadId: kotlin.String? = builder.workloadId
    /**
     * The name of the workload.
     *
     * The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.
     */
    public val workloadName: kotlin.String? = builder.workloadName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wellarchitected.model.ConsolidatedReportMetric = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConsolidatedReportMetric(")
        append("lenses=$lenses,")
        append("lensesAppliedCount=$lensesAppliedCount,")
        append("metricType=$metricType,")
        append("riskCounts=$riskCounts,")
        append("updatedAt=$updatedAt,")
        append("workloadArn=$workloadArn,")
        append("workloadId=$workloadId,")
        append("workloadName=$workloadName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lenses?.hashCode() ?: 0
        result = 31 * result + (lensesAppliedCount ?: 0)
        result = 31 * result + (metricType?.hashCode() ?: 0)
        result = 31 * result + (riskCounts?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (workloadArn?.hashCode() ?: 0)
        result = 31 * result + (workloadId?.hashCode() ?: 0)
        result = 31 * result + (workloadName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConsolidatedReportMetric

        if (lenses != other.lenses) return false
        if (lensesAppliedCount != other.lensesAppliedCount) return false
        if (metricType != other.metricType) return false
        if (riskCounts != other.riskCounts) return false
        if (updatedAt != other.updatedAt) return false
        if (workloadArn != other.workloadArn) return false
        if (workloadId != other.workloadId) return false
        if (workloadName != other.workloadName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wellarchitected.model.ConsolidatedReportMetric = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The metrics for the lenses in the workload.
         */
        public var lenses: List<LensMetric>? = null
        /**
         * The total number of lenses applied to the workload.
         */
        public var lensesAppliedCount: kotlin.Int? = null
        /**
         * The metric type of a metric in the consolidated report. Currently only WORKLOAD metric types are supported.
         */
        public var metricType: aws.sdk.kotlin.services.wellarchitected.model.MetricType? = null
        /**
         * A map from risk names to the count of how many questions have that rating.
         */
        public var riskCounts: Map<Risk, Int>? = null
        /**
         * The date and time recorded.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN for the workload.
         */
        public var workloadArn: kotlin.String? = null
        /**
         * The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.
         */
        public var workloadId: kotlin.String? = null
        /**
         * The name of the workload.
         *
         * The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.
         */
        public var workloadName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wellarchitected.model.ConsolidatedReportMetric) : this() {
            this.lenses = x.lenses
            this.lensesAppliedCount = x.lensesAppliedCount
            this.metricType = x.metricType
            this.riskCounts = x.riskCounts
            this.updatedAt = x.updatedAt
            this.workloadArn = x.workloadArn
            this.workloadId = x.workloadId
            this.workloadName = x.workloadName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wellarchitected.model.ConsolidatedReportMetric = ConsolidatedReportMetric(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
