// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.serde

import aws.sdk.kotlin.services.wellarchitected.model.AnswerSummary
import aws.sdk.kotlin.services.wellarchitected.model.ListAnswersResponse
import aws.sdk.kotlin.services.wellarchitected.model.WellArchitectedException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListAnswersOperationDeserializer: HttpDeserializer.NonStreaming<ListAnswersResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListAnswersResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListAnswersError(context, call, payload)
        }
        val builder = ListAnswersResponse.Builder()

        if (payload != null) {
            deserializeListAnswersOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListAnswersError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WellArchitectedException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WellArchitectedException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListAnswersOperationBody(builder: ListAnswersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ANSWERSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AnswerSummaries"))
    val LENSALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LensAlias"))
    val LENSARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LensArn"))
    val MILESTONENUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MilestoneNumber"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val WORKLOADID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WorkloadId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ANSWERSUMMARIES_DESCRIPTOR)
        field(LENSALIAS_DESCRIPTOR)
        field(LENSARN_DESCRIPTOR)
        field(MILESTONENUMBER_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(WORKLOADID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ANSWERSUMMARIES_DESCRIPTOR.index -> builder.answerSummaries =
                    deserializer.deserializeList(ANSWERSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AnswerSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAnswerSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LENSALIAS_DESCRIPTOR.index -> builder.lensAlias = deserializeString()
                LENSARN_DESCRIPTOR.index -> builder.lensArn = deserializeString()
                MILESTONENUMBER_DESCRIPTOR.index -> builder.milestoneNumber = deserializeInt()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                WORKLOADID_DESCRIPTOR.index -> builder.workloadId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
