// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.serde

import aws.sdk.kotlin.services.wellarchitected.model.AccountJiraConfigurationOutput
import aws.sdk.kotlin.services.wellarchitected.model.DiscoveryIntegrationStatus
import aws.sdk.kotlin.services.wellarchitected.model.GetGlobalSettingsResponse
import aws.sdk.kotlin.services.wellarchitected.model.OrganizationSharingStatus
import aws.sdk.kotlin.services.wellarchitected.model.WellArchitectedException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetGlobalSettingsOperationDeserializer: HttpDeserializer.NonStreaming<GetGlobalSettingsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetGlobalSettingsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetGlobalSettingsError(context, call, payload)
        }
        val builder = GetGlobalSettingsResponse.Builder()

        if (payload != null) {
            deserializeGetGlobalSettingsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetGlobalSettingsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WellArchitectedException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WellArchitectedException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetGlobalSettingsOperationBody(builder: GetGlobalSettingsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DISCOVERYINTEGRATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DiscoveryIntegrationStatus"))
    val JIRACONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("JiraConfiguration"))
    val ORGANIZATIONSHARINGSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("OrganizationSharingStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DISCOVERYINTEGRATIONSTATUS_DESCRIPTOR)
        field(JIRACONFIGURATION_DESCRIPTOR)
        field(ORGANIZATIONSHARINGSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DISCOVERYINTEGRATIONSTATUS_DESCRIPTOR.index -> builder.discoveryIntegrationStatus = deserializeString().let { DiscoveryIntegrationStatus.fromValue(it) }
                JIRACONFIGURATION_DESCRIPTOR.index -> builder.jiraConfiguration = deserializeAccountJiraConfigurationOutputDocument(deserializer)
                ORGANIZATIONSHARINGSTATUS_DESCRIPTOR.index -> builder.organizationSharingStatus = deserializeString().let { OrganizationSharingStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
