// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Input to update answer.
 */
public class UpdateAnswerRequest private constructor(builder: Builder) {
    /**
     * A list of choices to update on a question in your workload. The String key corresponds to the choice ID to be updated.
     */
    public val choiceUpdates: Map<String, ChoiceUpdate>? = builder.choiceUpdates
    /**
     * Defines whether this question is applicable to a lens review.
     */
    public val isApplicable: kotlin.Boolean? = builder.isApplicable
    /**
     * The alias of the lens.
     *
     * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-east-1::lens/serverless`. Note that some operations (such as ExportLens and CreateLensShare) are not permitted on Amazon Web Services official lenses.
     *
     * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef`.
     *
     * Each lens is identified by its LensSummary$LensAlias.
     */
    public val lensAlias: kotlin.String? = builder.lensAlias
    /**
     * The notes associated with the workload.
     *
     * For a review template, these are the notes that will be associated with the workload when the template is applied.
     */
    public val notes: kotlin.String? = builder.notes
    /**
     * The ID of the question.
     */
    public val questionId: kotlin.String? = builder.questionId
    /**
     * The reason why a question is not applicable to your workload.
     */
    public val reason: aws.sdk.kotlin.services.wellarchitected.model.AnswerReason? = builder.reason
    /**
     * List of selected choice IDs in a question answer.
     *
     * The values entered replace the previously selected choices.
     */
    public val selectedChoices: List<String>? = builder.selectedChoices
    /**
     * The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.
     */
    public val workloadId: kotlin.String? = builder.workloadId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wellarchitected.model.UpdateAnswerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAnswerRequest(")
        append("choiceUpdates=$choiceUpdates,")
        append("isApplicable=$isApplicable,")
        append("lensAlias=$lensAlias,")
        append("notes=$notes,")
        append("questionId=$questionId,")
        append("reason=$reason,")
        append("selectedChoices=$selectedChoices,")
        append("workloadId=$workloadId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = choiceUpdates?.hashCode() ?: 0
        result = 31 * result + (isApplicable?.hashCode() ?: 0)
        result = 31 * result + (lensAlias?.hashCode() ?: 0)
        result = 31 * result + (notes?.hashCode() ?: 0)
        result = 31 * result + (questionId?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (selectedChoices?.hashCode() ?: 0)
        result = 31 * result + (workloadId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAnswerRequest

        if (choiceUpdates != other.choiceUpdates) return false
        if (isApplicable != other.isApplicable) return false
        if (lensAlias != other.lensAlias) return false
        if (notes != other.notes) return false
        if (questionId != other.questionId) return false
        if (reason != other.reason) return false
        if (selectedChoices != other.selectedChoices) return false
        if (workloadId != other.workloadId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wellarchitected.model.UpdateAnswerRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of choices to update on a question in your workload. The String key corresponds to the choice ID to be updated.
         */
        public var choiceUpdates: Map<String, ChoiceUpdate>? = null
        /**
         * Defines whether this question is applicable to a lens review.
         */
        public var isApplicable: kotlin.Boolean? = null
        /**
         * The alias of the lens.
         *
         * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-east-1::lens/serverless`. Note that some operations (such as ExportLens and CreateLensShare) are not permitted on Amazon Web Services official lenses.
         *
         * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef`.
         *
         * Each lens is identified by its LensSummary$LensAlias.
         */
        public var lensAlias: kotlin.String? = null
        /**
         * The notes associated with the workload.
         *
         * For a review template, these are the notes that will be associated with the workload when the template is applied.
         */
        public var notes: kotlin.String? = null
        /**
         * The ID of the question.
         */
        public var questionId: kotlin.String? = null
        /**
         * The reason why a question is not applicable to your workload.
         */
        public var reason: aws.sdk.kotlin.services.wellarchitected.model.AnswerReason? = null
        /**
         * List of selected choice IDs in a question answer.
         *
         * The values entered replace the previously selected choices.
         */
        public var selectedChoices: List<String>? = null
        /**
         * The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.
         */
        public var workloadId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wellarchitected.model.UpdateAnswerRequest) : this() {
            this.choiceUpdates = x.choiceUpdates
            this.isApplicable = x.isApplicable
            this.lensAlias = x.lensAlias
            this.notes = x.notes
            this.questionId = x.questionId
            this.reason = x.reason
            this.selectedChoices = x.selectedChoices
            this.workloadId = x.workloadId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wellarchitected.model.UpdateAnswerRequest = UpdateAnswerRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
