// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A review template.
 */
public class ReviewTemplate private constructor(builder: Builder) {
    /**
     * The review template description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The lenses applied to the review template.
     */
    public val lenses: List<String>? = builder.lenses
    /**
     * The notes associated with the workload.
     *
     * For a review template, these are the notes that will be associated with the workload when the template is applied.
     */
    public val notes: kotlin.String? = builder.notes
    /**
     * An Amazon Web Services account ID.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * A count of how many total questions are answered and unanswered in the review template.
     */
    public val questionCounts: Map<Question, Int>? = builder.questionCounts
    /**
     * The ID assigned to the template share invitation.
     */
    public val shareInvitationId: kotlin.String? = builder.shareInvitationId
    /**
     * The tags assigned to the review template.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The review template ARN.
     */
    public val templateArn: kotlin.String? = builder.templateArn
    /**
     * The name of the review template.
     */
    public val templateName: kotlin.String? = builder.templateName
    /**
     * The latest status of a review template.
     */
    public val updateStatus: aws.sdk.kotlin.services.wellarchitected.model.ReviewTemplateUpdateStatus? = builder.updateStatus
    /**
     * The date and time recorded.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wellarchitected.model.ReviewTemplate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReviewTemplate(")
        append("description=$description,")
        append("lenses=$lenses,")
        append("notes=$notes,")
        append("owner=$owner,")
        append("questionCounts=$questionCounts,")
        append("shareInvitationId=$shareInvitationId,")
        append("tags=$tags,")
        append("templateArn=$templateArn,")
        append("templateName=$templateName,")
        append("updateStatus=$updateStatus,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (lenses?.hashCode() ?: 0)
        result = 31 * result + (notes?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (questionCounts?.hashCode() ?: 0)
        result = 31 * result + (shareInvitationId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateArn?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        result = 31 * result + (updateStatus?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReviewTemplate

        if (description != other.description) return false
        if (lenses != other.lenses) return false
        if (notes != other.notes) return false
        if (owner != other.owner) return false
        if (questionCounts != other.questionCounts) return false
        if (shareInvitationId != other.shareInvitationId) return false
        if (tags != other.tags) return false
        if (templateArn != other.templateArn) return false
        if (templateName != other.templateName) return false
        if (updateStatus != other.updateStatus) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wellarchitected.model.ReviewTemplate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The review template description.
         */
        public var description: kotlin.String? = null
        /**
         * The lenses applied to the review template.
         */
        public var lenses: List<String>? = null
        /**
         * The notes associated with the workload.
         *
         * For a review template, these are the notes that will be associated with the workload when the template is applied.
         */
        public var notes: kotlin.String? = null
        /**
         * An Amazon Web Services account ID.
         */
        public var owner: kotlin.String? = null
        /**
         * A count of how many total questions are answered and unanswered in the review template.
         */
        public var questionCounts: Map<Question, Int>? = null
        /**
         * The ID assigned to the template share invitation.
         */
        public var shareInvitationId: kotlin.String? = null
        /**
         * The tags assigned to the review template.
         */
        public var tags: Map<String, String>? = null
        /**
         * The review template ARN.
         */
        public var templateArn: kotlin.String? = null
        /**
         * The name of the review template.
         */
        public var templateName: kotlin.String? = null
        /**
         * The latest status of a review template.
         */
        public var updateStatus: aws.sdk.kotlin.services.wellarchitected.model.ReviewTemplateUpdateStatus? = null
        /**
         * The date and time recorded.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wellarchitected.model.ReviewTemplate) : this() {
            this.description = x.description
            this.lenses = x.lenses
            this.notes = x.notes
            this.owner = x.owner
            this.questionCounts = x.questionCounts
            this.shareInvitationId = x.shareInvitationId
            this.tags = x.tags
            this.templateArn = x.templateArn
            this.templateName = x.templateName
            this.updateStatus = x.updateStatus
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wellarchitected.model.ReviewTemplate = ReviewTemplate(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
