// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ImportLensRequest private constructor(builder: Builder) {
    /**
     * A unique case-sensitive string used to ensure that this request is idempotent (executes only once).
     *
     * You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after the original request has completed successfully, the result of the original request is returned.
     *
     * This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The JSON representation of a lens.
     */
    public val jsonString: kotlin.String? = builder.jsonString
    /**
     * The alias of the lens.
     *
     * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-east-1::lens/serverless`. Note that some operations (such as ExportLens and CreateLensShare) are not permitted on Amazon Web Services official lenses.
     *
     * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef`.
     *
     * Each lens is identified by its LensSummary$LensAlias.
     */
    public val lensAlias: kotlin.String? = builder.lensAlias
    /**
     * Tags to associate to a lens.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wellarchitected.model.ImportLensRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportLensRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("jsonString=$jsonString,")
        append("lensAlias=$lensAlias,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (jsonString?.hashCode() ?: 0)
        result = 31 * result + (lensAlias?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportLensRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (jsonString != other.jsonString) return false
        if (lensAlias != other.lensAlias) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wellarchitected.model.ImportLensRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique case-sensitive string used to ensure that this request is idempotent (executes only once).
         *
         * You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after the original request has completed successfully, the result of the original request is returned.
         *
         * This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The JSON representation of a lens.
         */
        public var jsonString: kotlin.String? = null
        /**
         * The alias of the lens.
         *
         * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-east-1::lens/serverless`. Note that some operations (such as ExportLens and CreateLensShare) are not permitted on Amazon Web Services official lenses.
         *
         * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef`.
         *
         * Each lens is identified by its LensSummary$LensAlias.
         */
        public var lensAlias: kotlin.String? = null
        /**
         * Tags to associate to a lens.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wellarchitected.model.ImportLensRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.jsonString = x.jsonString
            this.lensAlias = x.lensAlias
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wellarchitected.model.ImportLensRequest = ImportLensRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
