// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.serde

import aws.sdk.kotlin.services.wafv2.model.GetRuleGroupResponse
import aws.sdk.kotlin.services.wafv2.model.RuleGroup
import aws.sdk.kotlin.services.wafv2.model.Wafv2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetRuleGroupOperationDeserializer: HttpDeserializer.NonStreaming<GetRuleGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetRuleGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetRuleGroupError(context, call, payload)
        }
        val builder = GetRuleGroupResponse.Builder()

        if (payload != null) {
            deserializeGetRuleGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetRuleGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw Wafv2Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFNonexistentItemException" -> WafNonexistentItemExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFInvalidOperationException" -> WafInvalidOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> Wafv2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRuleGroupOperationBody(builder: GetRuleGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LOCKTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LockToken"))
    val RULEGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RuleGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LOCKTOKEN_DESCRIPTOR)
        field(RULEGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LOCKTOKEN_DESCRIPTOR.index -> builder.lockToken = deserializeString()
                RULEGROUP_DESCRIPTOR.index -> builder.ruleGroup = deserializeRuleGroupDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
