// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.serde

import aws.sdk.kotlin.services.wafv2.model.DisassociateWebAclResponse
import aws.sdk.kotlin.services.wafv2.model.Wafv2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DisassociateWebACLOperationDeserializer: HttpDeserializer.NonStreaming<DisassociateWebAclResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DisassociateWebAclResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDisassociateWebAclError(context, call, payload)
        }
        val builder = DisassociateWebAclResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDisassociateWebAclError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw Wafv2Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFNonexistentItemException" -> WafNonexistentItemExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFInvalidOperationException" -> WafInvalidOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> Wafv2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
