// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateRuleGroupRequest private constructor(builder: Builder) {
    /**
     * A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.
     *
     * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *WAF Developer Guide*.
     *
     * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the *WAF Developer Guide*.
     */
    public val customResponseBodies: Map<String, CustomResponseBody>? = builder.customResponseBodies
    /**
     * A description of the rule group that helps with identification.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
     */
    public val id: kotlin.String? = builder.id
    /**
     * A token used for optimistic locking. WAF returns a token to your `get` and `list` requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like `update` and `delete`. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a `WAFOptimisticLockException`. If this happens, perform another `get`, and use the new token returned by that operation.
     */
    public val lockToken: kotlin.String? = builder.lockToken
    /**
     * The name of the rule group. You cannot change the name of a rule group after you create it.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Rule statements used to identify the web requests that you want to manage. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them.
     */
    public val rules: List<Rule>? = builder.rules
    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
     *
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * + CLI - Specify the Region when you use the CloudFront scope: `--scope=CLOUDFRONT --region=us-east-1`.
     * + API and SDKs - For all calls, use the Region endpoint us-east-1.
     */
    public val scope: aws.sdk.kotlin.services.wafv2.model.Scope? = builder.scope
    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    public val visibilityConfig: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig? = builder.visibilityConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.UpdateRuleGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateRuleGroupRequest(")
        append("customResponseBodies=$customResponseBodies,")
        append("description=$description,")
        append("id=$id,")
        append("lockToken=$lockToken,")
        append("name=$name,")
        append("rules=$rules,")
        append("scope=$scope,")
        append("visibilityConfig=$visibilityConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customResponseBodies?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lockToken?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (visibilityConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateRuleGroupRequest

        if (customResponseBodies != other.customResponseBodies) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lockToken != other.lockToken) return false
        if (name != other.name) return false
        if (rules != other.rules) return false
        if (scope != other.scope) return false
        if (visibilityConfig != other.visibilityConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.UpdateRuleGroupRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.
         *
         * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *WAF Developer Guide*.
         *
         * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the *WAF Developer Guide*.
         */
        public var customResponseBodies: Map<String, CustomResponseBody>? = null
        /**
         * A description of the rule group that helps with identification.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
         */
        public var id: kotlin.String? = null
        /**
         * A token used for optimistic locking. WAF returns a token to your `get` and `list` requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like `update` and `delete`. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a `WAFOptimisticLockException`. If this happens, perform another `get`, and use the new token returned by that operation.
         */
        public var lockToken: kotlin.String? = null
        /**
         * The name of the rule group. You cannot change the name of a rule group after you create it.
         */
        public var name: kotlin.String? = null
        /**
         * The Rule statements used to identify the web requests that you want to manage. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them.
         */
        public var rules: List<Rule>? = null
        /**
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
         *
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * + CLI - Specify the Region when you use the CloudFront scope: `--scope=CLOUDFRONT --region=us-east-1`.
         * + API and SDKs - For all calls, use the Region endpoint us-east-1.
         */
        public var scope: aws.sdk.kotlin.services.wafv2.model.Scope? = null
        /**
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         */
        public var visibilityConfig: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.UpdateRuleGroupRequest) : this() {
            this.customResponseBodies = x.customResponseBodies
            this.description = x.description
            this.id = x.id
            this.lockToken = x.lockToken
            this.name = x.name
            this.rules = x.rules
            this.scope = x.scope
            this.visibilityConfig = x.visibilityConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.UpdateRuleGroupRequest = UpdateRuleGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.VisibilityConfig] inside the given [block]
         */
        public fun visibilityConfig(block: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig.Builder.() -> kotlin.Unit) {
            this.visibilityConfig = aws.sdk.kotlin.services.wafv2.model.VisibilityConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
