// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.
 *
 * If you configure WAF to inspect the request body, WAF inspects only the number of bytes in the body up to the limit for the web ACL and protected resource type. If you know that the request body for your web requests should never exceed the inspection limit, you can use a size constraint statement to block requests that have a larger request body size. For more information about the inspection limits, see `Body` and `JsonBody` settings for the `FieldToMatch` data type.
 *
 * If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI `/logo.jpg` is nine characters long.
 */
public class SizeConstraintStatement private constructor(builder: Builder) {
    /**
     * The operator to use to compare the request part to the size setting.
     */
    public val comparisonOperator: aws.sdk.kotlin.services.wafv2.model.ComparisonOperator = requireNotNull(builder.comparisonOperator) { "A non-null value must be provided for comparisonOperator" }
    /**
     * The part of the web request that you want WAF to inspect.
     */
    public val fieldToMatch: aws.sdk.kotlin.services.wafv2.model.FieldToMatch? = builder.fieldToMatch
    /**
     * The size, in byte, to compare to the request part, after any transformations.
     */
    public val size: kotlin.Long = builder.size
    /**
     * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
     */
    public val textTransformations: List<TextTransformation> = requireNotNull(builder.textTransformations) { "A non-null value must be provided for textTransformations" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SizeConstraintStatement(")
        append("comparisonOperator=$comparisonOperator,")
        append("fieldToMatch=$fieldToMatch,")
        append("size=$size,")
        append("textTransformations=$textTransformations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = comparisonOperator.hashCode()
        result = 31 * result + (fieldToMatch?.hashCode() ?: 0)
        result = 31 * result + (size.hashCode())
        result = 31 * result + (textTransformations.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SizeConstraintStatement

        if (comparisonOperator != other.comparisonOperator) return false
        if (fieldToMatch != other.fieldToMatch) return false
        if (size != other.size) return false
        if (textTransformations != other.textTransformations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The operator to use to compare the request part to the size setting.
         */
        public var comparisonOperator: aws.sdk.kotlin.services.wafv2.model.ComparisonOperator? = null
        /**
         * The part of the web request that you want WAF to inspect.
         */
        public var fieldToMatch: aws.sdk.kotlin.services.wafv2.model.FieldToMatch? = null
        /**
         * The size, in byte, to compare to the request part, after any transformations.
         */
        public var size: kotlin.Long = 0L
        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
         */
        public var textTransformations: List<TextTransformation>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement) : this() {
            this.comparisonOperator = x.comparisonOperator
            this.fieldToMatch = x.fieldToMatch
            this.size = x.size
            this.textTransformations = x.textTransformations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement = SizeConstraintStatement(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.FieldToMatch] inside the given [block]
         */
        public fun fieldToMatch(block: aws.sdk.kotlin.services.wafv2.model.FieldToMatch.Builder.() -> kotlin.Unit) {
            this.fieldToMatch = aws.sdk.kotlin.services.wafv2.model.FieldToMatch.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (comparisonOperator == null) comparisonOperator = ComparisonOperator.SdkUnknown("no value provided")
            if (textTransformations == null) textTransformations = emptyList()
            return this
        }
    }
}
