// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A rule statement used to search web request components for a match against a single regular expression.
 */
public class RegexMatchStatement private constructor(builder: Builder) {
    /**
     * The part of the web request that you want WAF to inspect.
     */
    public val fieldToMatch: aws.sdk.kotlin.services.wafv2.model.FieldToMatch? = builder.fieldToMatch
    /**
     * The string representing the regular expression.
     */
    public val regexString: kotlin.String = requireNotNull(builder.regexString) { "A non-null value must be provided for regexString" }
    /**
     * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
     */
    public val textTransformations: List<TextTransformation> = requireNotNull(builder.textTransformations) { "A non-null value must be provided for textTransformations" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RegexMatchStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegexMatchStatement(")
        append("fieldToMatch=$fieldToMatch,")
        append("regexString=$regexString,")
        append("textTransformations=$textTransformations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fieldToMatch?.hashCode() ?: 0
        result = 31 * result + (regexString.hashCode())
        result = 31 * result + (textTransformations.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegexMatchStatement

        if (fieldToMatch != other.fieldToMatch) return false
        if (regexString != other.regexString) return false
        if (textTransformations != other.textTransformations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RegexMatchStatement = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The part of the web request that you want WAF to inspect.
         */
        public var fieldToMatch: aws.sdk.kotlin.services.wafv2.model.FieldToMatch? = null
        /**
         * The string representing the regular expression.
         */
        public var regexString: kotlin.String? = null
        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
         */
        public var textTransformations: List<TextTransformation>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RegexMatchStatement) : this() {
            this.fieldToMatch = x.fieldToMatch
            this.regexString = x.regexString
            this.textTransformations = x.textTransformations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RegexMatchStatement = RegexMatchStatement(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.FieldToMatch] inside the given [block]
         */
        public fun fieldToMatch(block: aws.sdk.kotlin.services.wafv2.model.FieldToMatch.Builder.() -> kotlin.Unit) {
            this.fieldToMatch = aws.sdk.kotlin.services.wafv2.model.FieldToMatch.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (regexString == null) regexString = ""
            if (textTransformations == null) textTransformations = emptyList()
            return this
        }
    }
}
