// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor name and the name of the rule group in this statement. You can retrieve the required names by calling ListAvailableManagedRuleGroups.
 *
 * You cannot nest a `ManagedRuleGroupStatement`, for example for use inside a `NotStatement` or `OrStatement`. You cannot use a managed rule group inside another rule group. You can only reference a managed rule group as a top-level statement within a rule that you define in a web ACL.
 *
 * You are charged additional fees when you use the WAF Bot Control managed rule group `AWSManagedRulesBotControlRuleSet`, the WAF Fraud Control account takeover prevention (ATP) managed rule group `AWSManagedRulesATPRuleSet`, or the WAF Fraud Control account creation fraud prevention (ACFP) managed rule group `AWSManagedRulesACFPRuleSet`. For more information, see [WAF Pricing](http://aws.amazon.com/waf/pricing/).
 */
public class ManagedRuleGroupStatement private constructor(builder: Builder) {
    /**
     * Rules in the referenced rule group whose actions are set to `Count`.
     *
     * Instead of this option, use `RuleActionOverrides`. It accepts any valid action setting, including `Count`.
     */
    public val excludedRules: List<ExcludedRule>? = builder.excludedRules
    /**
     * Additional information that's used by a managed rule group. Many managed rule groups don't require this.
     *
     * The rule groups used for intelligent threat mitigation require additional configuration:
     * + Use the `AWSManagedRulesACFPRuleSet` configuration object to configure the account creation fraud prevention managed rule group. The configuration includes the registration and sign-up pages of your application and the locations in the account creation request payload of data, such as the user email and phone number fields.
     * + Use the `AWSManagedRulesATPRuleSet` configuration object to configure the account takeover prevention managed rule group. The configuration includes the sign-in page of your application and the locations in the login request payload of data such as the username and password.
     * + Use the `AWSManagedRulesBotControlRuleSet` configuration object to configure the protection level that you want the Bot Control rule group to use.
     */
    public val managedRuleGroupConfigs: List<ManagedRuleGroupConfig>? = builder.managedRuleGroupConfigs
    /**
     * The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change.
     *
     * You can use overrides for testing, for example you can override all of rule actions to `Count` and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.
     */
    public val ruleActionOverrides: List<RuleActionOverride>? = builder.ruleActionOverrides
    /**
     * An optional nested statement that narrows the scope of the web requests that are evaluated by the managed rule group. Requests are only evaluated by the rule group if they match the scope-down statement. You can use any nestable Statement in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
     */
    public val scopeDownStatement: aws.sdk.kotlin.services.wafv2.model.Statement? = builder.scopeDownStatement
    /**
     * The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule group.
     */
    public val vendorName: kotlin.String = requireNotNull(builder.vendorName) { "A non-null value must be provided for vendorName" }
    /**
     * The version of the managed rule group to use. If you specify this, the version setting is fixed until you change it. If you don't specify this, WAF uses the vendor's default version, and then keeps the version at the vendor's default when the vendor updates the managed rule group settings.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ManagedRuleGroupStatement(")
        append("excludedRules=$excludedRules,")
        append("managedRuleGroupConfigs=$managedRuleGroupConfigs,")
        append("name=$name,")
        append("ruleActionOverrides=$ruleActionOverrides,")
        append("scopeDownStatement=$scopeDownStatement,")
        append("vendorName=$vendorName,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = excludedRules?.hashCode() ?: 0
        result = 31 * result + (managedRuleGroupConfigs?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (ruleActionOverrides?.hashCode() ?: 0)
        result = 31 * result + (scopeDownStatement?.hashCode() ?: 0)
        result = 31 * result + (vendorName.hashCode())
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ManagedRuleGroupStatement

        if (excludedRules != other.excludedRules) return false
        if (managedRuleGroupConfigs != other.managedRuleGroupConfigs) return false
        if (name != other.name) return false
        if (ruleActionOverrides != other.ruleActionOverrides) return false
        if (scopeDownStatement != other.scopeDownStatement) return false
        if (vendorName != other.vendorName) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Rules in the referenced rule group whose actions are set to `Count`.
         *
         * Instead of this option, use `RuleActionOverrides`. It accepts any valid action setting, including `Count`.
         */
        public var excludedRules: List<ExcludedRule>? = null
        /**
         * Additional information that's used by a managed rule group. Many managed rule groups don't require this.
         *
         * The rule groups used for intelligent threat mitigation require additional configuration:
         * + Use the `AWSManagedRulesACFPRuleSet` configuration object to configure the account creation fraud prevention managed rule group. The configuration includes the registration and sign-up pages of your application and the locations in the account creation request payload of data, such as the user email and phone number fields.
         * + Use the `AWSManagedRulesATPRuleSet` configuration object to configure the account takeover prevention managed rule group. The configuration includes the sign-in page of your application and the locations in the login request payload of data such as the username and password.
         * + Use the `AWSManagedRulesBotControlRuleSet` configuration object to configure the protection level that you want the Bot Control rule group to use.
         */
        public var managedRuleGroupConfigs: List<ManagedRuleGroupConfig>? = null
        /**
         * The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
         */
        public var name: kotlin.String? = null
        /**
         * Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change.
         *
         * You can use overrides for testing, for example you can override all of rule actions to `Count` and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.
         */
        public var ruleActionOverrides: List<RuleActionOverride>? = null
        /**
         * An optional nested statement that narrows the scope of the web requests that are evaluated by the managed rule group. Requests are only evaluated by the rule group if they match the scope-down statement. You can use any nestable Statement in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
         */
        public var scopeDownStatement: aws.sdk.kotlin.services.wafv2.model.Statement? = null
        /**
         * The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule group.
         */
        public var vendorName: kotlin.String? = null
        /**
         * The version of the managed rule group to use. If you specify this, the version setting is fixed until you change it. If you don't specify this, WAF uses the vendor's default version, and then keeps the version at the vendor's default when the vendor updates the managed rule group settings.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement) : this() {
            this.excludedRules = x.excludedRules
            this.managedRuleGroupConfigs = x.managedRuleGroupConfigs
            this.name = x.name
            this.ruleActionOverrides = x.ruleActionOverrides
            this.scopeDownStatement = x.scopeDownStatement
            this.vendorName = x.vendorName
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement = ManagedRuleGroupStatement(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.Statement] inside the given [block]
         */
        public fun scopeDownStatement(block: aws.sdk.kotlin.services.wafv2.model.Statement.Builder.() -> kotlin.Unit) {
            this.scopeDownStatement = aws.sdk.kotlin.services.wafv2.model.Statement.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (vendorName == null) vendorName = ""
            return this
        }
    }
}
