// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * High-level information about an IPSet, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage an `IPSet`, and the ARN, that you provide to the IPSetReferenceStatement to use the address set in a Rule.
 */
public class IpSetSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the entity.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A description of the IP set that helps with identification.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
     */
    public val id: kotlin.String? = builder.id
    /**
     * A token used for optimistic locking. WAF returns a token to your `get` and `list` requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like `update` and `delete`. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a `WAFOptimisticLockException`. If this happens, perform another `get`, and use the new token returned by that operation.
     */
    public val lockToken: kotlin.String? = builder.lockToken
    /**
     * The name of the IP set. You cannot change the name of an `IPSet` after you create it.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.IpSetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpSetSummary(")
        append("arn=$arn,")
        append("description=$description,")
        append("id=$id,")
        append("lockToken=$lockToken,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lockToken?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IpSetSummary

        if (arn != other.arn) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lockToken != other.lockToken) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.IpSetSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the entity.
         */
        public var arn: kotlin.String? = null
        /**
         * A description of the IP set that helps with identification.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
         */
        public var id: kotlin.String? = null
        /**
         * A token used for optimistic locking. WAF returns a token to your `get` and `list` requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like `update` and `delete`. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a `WAFOptimisticLockException`. If this happens, perform another `get`, and use the new token returned by that operation.
         */
        public var lockToken: kotlin.String? = null
        /**
         * The name of the IP set. You cannot change the name of an `IPSet` after you create it.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.IpSetSummary) : this() {
            this.arn = x.arn
            this.description = x.description
            this.id = x.id
            this.lockToken = x.lockToken
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.IpSetSummary = IpSetSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
