// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A rule statement that labels web requests by country and region and that matches against web requests based on country code. A geo match rule labels every request that it inspects regardless of whether it finds a match.
 * + To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the `CountryCodes` array.
 * + Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.
 *
 * WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match `ForwardedIPConfig`.
 *
 * If you use the web request origin, the label formats are `awswaf:clientip:geo:region:<ISO country code>-<ISO region code>` and `awswaf:clientip:geo:country:<ISO country code>`.
 *
 * If you use a forwarded IP address, the label formats are `awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>` and `awswaf:forwardedip:geo:country:<ISO country code>`.
 *
 * For additional details, see [Geographic match rule statement](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
 */
public class GeoMatchStatement private constructor(builder: Builder) {
    /**
     * An array of two-character country codes that you want to match against, for example, `[ "US", "CN" ]`, from the alpha-2 country ISO codes of the ISO 3166 international standard.
     *
     * When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.
     */
    public val countryCodes: List<CountryCode>? = builder.countryCodes
    /**
     * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
     *
     * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
     */
    public val forwardedIpConfig: aws.sdk.kotlin.services.wafv2.model.ForwardedIpConfig? = builder.forwardedIpConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.GeoMatchStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GeoMatchStatement(")
        append("countryCodes=$countryCodes,")
        append("forwardedIpConfig=$forwardedIpConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = countryCodes?.hashCode() ?: 0
        result = 31 * result + (forwardedIpConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GeoMatchStatement

        if (countryCodes != other.countryCodes) return false
        if (forwardedIpConfig != other.forwardedIpConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.GeoMatchStatement = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of two-character country codes that you want to match against, for example, `[ "US", "CN" ]`, from the alpha-2 country ISO codes of the ISO 3166 international standard.
         *
         * When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.
         */
        public var countryCodes: List<CountryCode>? = null
        /**
         * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
         *
         * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
         */
        public var forwardedIpConfig: aws.sdk.kotlin.services.wafv2.model.ForwardedIpConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.GeoMatchStatement) : this() {
            this.countryCodes = x.countryCodes
            this.forwardedIpConfig = x.forwardedIpConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.GeoMatchStatement = GeoMatchStatement(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.ForwardedIpConfig] inside the given [block]
         */
        public fun forwardedIpConfig(block: aws.sdk.kotlin.services.wafv2.model.ForwardedIpConfig.Builder.() -> kotlin.Unit) {
            this.forwardedIpConfig = aws.sdk.kotlin.services.wafv2.model.ForwardedIpConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
