// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeManagedRuleGroupRequest private constructor(builder: Builder) {
    /**
     * The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
     *
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * + CLI - Specify the Region when you use the CloudFront scope: `--scope=CLOUDFRONT --region=us-east-1`.
     * + API and SDKs - For all calls, use the Region endpoint us-east-1.
     */
    public val scope: aws.sdk.kotlin.services.wafv2.model.Scope? = builder.scope
    /**
     * The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule group.
     */
    public val vendorName: kotlin.String? = builder.vendorName
    /**
     * The version of the rule group. You can only use a version that is not scheduled for expiration. If you don't provide this, WAF uses the vendor's default version.
     */
    public val versionName: kotlin.String? = builder.versionName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.DescribeManagedRuleGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeManagedRuleGroupRequest(")
        append("name=$name,")
        append("scope=$scope,")
        append("vendorName=$vendorName,")
        append("versionName=$versionName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (vendorName?.hashCode() ?: 0)
        result = 31 * result + (versionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeManagedRuleGroupRequest

        if (name != other.name) return false
        if (scope != other.scope) return false
        if (vendorName != other.vendorName) return false
        if (versionName != other.versionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.DescribeManagedRuleGroupRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
         *
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * + CLI - Specify the Region when you use the CloudFront scope: `--scope=CLOUDFRONT --region=us-east-1`.
         * + API and SDKs - For all calls, use the Region endpoint us-east-1.
         */
        public var scope: aws.sdk.kotlin.services.wafv2.model.Scope? = null
        /**
         * The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule group.
         */
        public var vendorName: kotlin.String? = null
        /**
         * The version of the rule group. You can only use a version that is not scheduled for expiration. If you don't provide this, WAF uses the vendor's default version.
         */
        public var versionName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.DescribeManagedRuleGroupRequest) : this() {
            this.name = x.name
            this.scope = x.scope
            this.vendorName = x.vendorName
            this.versionName = x.versionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.DescribeManagedRuleGroupRequest = DescribeManagedRuleGroupRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
