// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The response body to use in a custom response to a web request. This is referenced by key from CustomResponse`CustomResponseBodyKey`.
 */
public class CustomResponseBody private constructor(builder: Builder) {
    /**
     * The payload of the custom response.
     *
     * You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the `ContentType` setting.
     *
     * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the *WAF Developer Guide*.
     */
    public val content: kotlin.String = requireNotNull(builder.content) { "A non-null value must be provided for content" }
    /**
     * The type of content in the payload that you are defining in the `Content` string.
     */
    public val contentType: aws.sdk.kotlin.services.wafv2.model.ResponseContentType = requireNotNull(builder.contentType) { "A non-null value must be provided for contentType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.CustomResponseBody = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomResponseBody(")
        append("content=$content,")
        append("contentType=$contentType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = content.hashCode()
        result = 31 * result + (contentType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomResponseBody

        if (content != other.content) return false
        if (contentType != other.contentType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.CustomResponseBody = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The payload of the custom response.
         *
         * You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the `ContentType` setting.
         *
         * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the *WAF Developer Guide*.
         */
        public var content: kotlin.String? = null
        /**
         * The type of content in the payload that you are defining in the `Content` string.
         */
        public var contentType: aws.sdk.kotlin.services.wafv2.model.ResponseContentType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.CustomResponseBody) : this() {
            this.content = x.content
            this.contentType = x.contentType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.CustomResponseBody = CustomResponseBody(this)

        internal fun correctErrors(): Builder {
            if (content == null) content = ""
            if (contentType == null) contentType = ResponseContentType.SdkUnknown("no value provided")
            return this
        }
    }
}
