// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details for your use of the account creation fraud prevention managed rule group, `AWSManagedRulesACFPRuleSet`. This configuration is used in `ManagedRuleGroupConfig`.
 */
public class AwsManagedRulesAcfpRuleSet private constructor(builder: Builder) {
    /**
     * The path of the account creation endpoint for your application. This is the page on your website that accepts the completed registration form for a new user. This page must accept `POST` requests.
     *
     * For example, for the URL `https://example.com/web/newaccount`, you would provide the path `/web/newaccount`. Account creation page paths that start with the path that you provide are considered a match. For example `/web/newaccount` matches the account creation paths `/web/newaccount`, `/web/newaccount/`, `/web/newaccountPage`, and `/web/newaccount/thisPage`, but doesn't match the path `/home/web/newaccount` or `/website/newaccount`.
     */
    public val creationPath: kotlin.String = requireNotNull(builder.creationPath) { "A non-null value must be provided for creationPath" }
    /**
     * Allow the use of regular expressions in the registration page path and the account creation path.
     */
    public val enableRegexInPath: kotlin.Boolean = builder.enableRegexInPath
    /**
     * The path of the account registration endpoint for your application. This is the page on your website that presents the registration form to new users.
     *
     * This page must accept `GET` text/html requests.
     *
     * For example, for the URL `https://example.com/web/registration`, you would provide the path `/web/registration`. Registration page paths that start with the path that you provide are considered a match. For example `/web/registration` matches the registration paths `/web/registration`, `/web/registration/`, `/web/registrationPage`, and `/web/registration/thisPage`, but doesn't match the path `/home/web/registration` or `/website/registration`.
     */
    public val registrationPagePath: kotlin.String = requireNotNull(builder.registrationPagePath) { "A non-null value must be provided for registrationPagePath" }
    /**
     * The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track account creation attempts.
     */
    public val requestInspection: aws.sdk.kotlin.services.wafv2.model.RequestInspectionAcfp? = builder.requestInspection
    /**
     * The criteria for inspecting responses to account creation requests, used by the ACFP rule group to track account creation success rates.
     *
     * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
     *
     * The ACFP rule group evaluates the responses that your protected resources send back to client account creation attempts, keeping count of successful and failed attempts from each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many successful account creation attempts in a short amount of time.
     */
    public val responseInspection: aws.sdk.kotlin.services.wafv2.model.ResponseInspection? = builder.responseInspection

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesAcfpRuleSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsManagedRulesAcfpRuleSet(")
        append("creationPath=$creationPath,")
        append("enableRegexInPath=$enableRegexInPath,")
        append("registrationPagePath=$registrationPagePath,")
        append("requestInspection=$requestInspection,")
        append("responseInspection=$responseInspection")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationPath.hashCode()
        result = 31 * result + (enableRegexInPath.hashCode())
        result = 31 * result + (registrationPagePath.hashCode())
        result = 31 * result + (requestInspection?.hashCode() ?: 0)
        result = 31 * result + (responseInspection?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsManagedRulesAcfpRuleSet

        if (creationPath != other.creationPath) return false
        if (enableRegexInPath != other.enableRegexInPath) return false
        if (registrationPagePath != other.registrationPagePath) return false
        if (requestInspection != other.requestInspection) return false
        if (responseInspection != other.responseInspection) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesAcfpRuleSet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The path of the account creation endpoint for your application. This is the page on your website that accepts the completed registration form for a new user. This page must accept `POST` requests.
         *
         * For example, for the URL `https://example.com/web/newaccount`, you would provide the path `/web/newaccount`. Account creation page paths that start with the path that you provide are considered a match. For example `/web/newaccount` matches the account creation paths `/web/newaccount`, `/web/newaccount/`, `/web/newaccountPage`, and `/web/newaccount/thisPage`, but doesn't match the path `/home/web/newaccount` or `/website/newaccount`.
         */
        public var creationPath: kotlin.String? = null
        /**
         * Allow the use of regular expressions in the registration page path and the account creation path.
         */
        public var enableRegexInPath: kotlin.Boolean = false
        /**
         * The path of the account registration endpoint for your application. This is the page on your website that presents the registration form to new users.
         *
         * This page must accept `GET` text/html requests.
         *
         * For example, for the URL `https://example.com/web/registration`, you would provide the path `/web/registration`. Registration page paths that start with the path that you provide are considered a match. For example `/web/registration` matches the registration paths `/web/registration`, `/web/registration/`, `/web/registrationPage`, and `/web/registration/thisPage`, but doesn't match the path `/home/web/registration` or `/website/registration`.
         */
        public var registrationPagePath: kotlin.String? = null
        /**
         * The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track account creation attempts.
         */
        public var requestInspection: aws.sdk.kotlin.services.wafv2.model.RequestInspectionAcfp? = null
        /**
         * The criteria for inspecting responses to account creation requests, used by the ACFP rule group to track account creation success rates.
         *
         * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
         *
         * The ACFP rule group evaluates the responses that your protected resources send back to client account creation attempts, keeping count of successful and failed attempts from each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many successful account creation attempts in a short amount of time.
         */
        public var responseInspection: aws.sdk.kotlin.services.wafv2.model.ResponseInspection? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesAcfpRuleSet) : this() {
            this.creationPath = x.creationPath
            this.enableRegexInPath = x.enableRegexInPath
            this.registrationPagePath = x.registrationPagePath
            this.requestInspection = x.requestInspection
            this.responseInspection = x.responseInspection
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesAcfpRuleSet = AwsManagedRulesAcfpRuleSet(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RequestInspectionAcfp] inside the given [block]
         */
        public fun requestInspection(block: aws.sdk.kotlin.services.wafv2.model.RequestInspectionAcfp.Builder.() -> kotlin.Unit) {
            this.requestInspection = aws.sdk.kotlin.services.wafv2.model.RequestInspectionAcfp.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.ResponseInspection] inside the given [block]
         */
        public fun responseInspection(block: aws.sdk.kotlin.services.wafv2.model.ResponseInspection.Builder.() -> kotlin.Unit) {
            this.responseInspection = aws.sdk.kotlin.services.wafv2.model.ResponseInspection.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (creationPath == null) creationPath = ""
            if (registrationPagePath == null) registrationPagePath = ""
            return this
        }
    }
}
