// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.serde

import aws.sdk.kotlin.services.wafv2.model.LoggingConfiguration
import aws.sdk.kotlin.services.wafv2.model.PutLoggingConfigurationResponse
import aws.sdk.kotlin.services.wafv2.model.Wafv2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutLoggingConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<PutLoggingConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutLoggingConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutLoggingConfigurationError(context, call, payload)
        }
        val builder = PutLoggingConfigurationResponse.Builder()

        if (payload != null) {
            deserializePutLoggingConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutLoggingConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw Wafv2Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFOptimisticLockException" -> WafOptimisticLockExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFNonexistentItemException" -> WafNonexistentItemExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFInvalidOperationException" -> WafInvalidOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFLimitsExceededException" -> WafLimitsExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFLogDestinationPermissionIssueException" -> WafLogDestinationPermissionIssueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFServiceLinkedRoleErrorException" -> WafServiceLinkedRoleErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> Wafv2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutLoggingConfigurationOperationBody(builder: PutLoggingConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LOGGINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LoggingConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LOGGINGCONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LOGGINGCONFIGURATION_DESCRIPTOR.index -> builder.loggingConfiguration = deserializeLoggingConfigurationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
