// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateIpSetRequest private constructor(builder: Builder) {
    /**
     * Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you want WAF to inspect for in incoming requests. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for `/0`.
     *
     * Example address strings:
     * + For requests that originated from the IP address 192.0.2.44, specify `192.0.2.44/32`.
     * + For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify `192.0.2.0/24`.
     * + For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify `1111:0000:0000:0000:0000:0000:0000:0111/128`.
     * + For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify `1111:0000:0000:0000:0000:0000:0000:0000/64`.
     *
     * For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
     *
     * Example JSON `Addresses` specifications:
     * + Empty array: `"Addresses": []`
     * + Array with one address: `"Addresses": ["192.0.2.44/32"]`
     * + Array with three addresses: `"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]`
     * + INVALID specification: `"Addresses": [""]` INVALID
     */
    public val addresses: List<String>? = builder.addresses
    /**
     * A description of the IP set that helps with identification.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
     */
    public val id: kotlin.String? = builder.id
    /**
     * A token used for optimistic locking. WAF returns a token to your `get` and `list` requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like `update` and `delete`. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a `WAFOptimisticLockException`. If this happens, perform another `get`, and use the new token returned by that operation.
     */
    public val lockToken: kotlin.String? = builder.lockToken
    /**
     * The name of the IP set. You cannot change the name of an `IPSet` after you create it.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
     *
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * + CLI - Specify the Region when you use the CloudFront scope: `--scope=CLOUDFRONT --region=us-east-1`.
     * + API and SDKs - For all calls, use the Region endpoint us-east-1.
     */
    public val scope: aws.sdk.kotlin.services.wafv2.model.Scope? = builder.scope

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.UpdateIpSetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateIpSetRequest(")
        append("addresses=$addresses,")
        append("description=$description,")
        append("id=$id,")
        append("lockToken=$lockToken,")
        append("name=$name,")
        append("scope=$scope")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addresses?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lockToken?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateIpSetRequest

        if (addresses != other.addresses) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lockToken != other.lockToken) return false
        if (name != other.name) return false
        if (scope != other.scope) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.UpdateIpSetRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you want WAF to inspect for in incoming requests. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for `/0`.
         *
         * Example address strings:
         * + For requests that originated from the IP address 192.0.2.44, specify `192.0.2.44/32`.
         * + For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify `192.0.2.0/24`.
         * + For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify `1111:0000:0000:0000:0000:0000:0000:0111/128`.
         * + For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify `1111:0000:0000:0000:0000:0000:0000:0000/64`.
         *
         * For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
         *
         * Example JSON `Addresses` specifications:
         * + Empty array: `"Addresses": []`
         * + Array with one address: `"Addresses": ["192.0.2.44/32"]`
         * + Array with three addresses: `"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]`
         * + INVALID specification: `"Addresses": [""]` INVALID
         */
        public var addresses: List<String>? = null
        /**
         * A description of the IP set that helps with identification.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
         */
        public var id: kotlin.String? = null
        /**
         * A token used for optimistic locking. WAF returns a token to your `get` and `list` requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like `update` and `delete`. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a `WAFOptimisticLockException`. If this happens, perform another `get`, and use the new token returned by that operation.
         */
        public var lockToken: kotlin.String? = null
        /**
         * The name of the IP set. You cannot change the name of an `IPSet` after you create it.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
         *
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * + CLI - Specify the Region when you use the CloudFront scope: `--scope=CLOUDFRONT --region=us-east-1`.
         * + API and SDKs - For all calls, use the Region endpoint us-east-1.
         */
        public var scope: aws.sdk.kotlin.services.wafv2.model.Scope? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.UpdateIpSetRequest) : this() {
            this.addresses = x.addresses
            this.description = x.description
            this.id = x.id
            this.lockToken = x.lockToken
            this.name = x.name
            this.scope = x.scope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.UpdateIpSetRequest = UpdateIpSetRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
