// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configures inspection of the response status code. This is part of the `ResponseInspection` configuration for `AWSManagedRulesATPRuleSet` and `AWSManagedRulesACFPRuleSet`.
 *
 * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
 */
public class ResponseInspectionStatusCode private constructor(builder: Builder) {
    /**
     * Status codes in the response that indicate a failed login or account creation attempt. To be counted as a failure, the response status code must match one of these. Each code must be unique among the success and failure status codes.
     *
     * JSON example: `"FailureCodes": [ 400, 404 ]`
     */
    public val failureCodes: List<Int> = requireNotNull(builder.failureCodes) { "A non-null value must be provided for failureCodes" }
    /**
     * Status codes in the response that indicate a successful login or account creation attempt. To be counted as a success, the response status code must match one of these. Each code must be unique among the success and failure status codes.
     *
     * JSON example: `"SuccessCodes": [ 200, 201 ]`
     */
    public val successCodes: List<Int> = requireNotNull(builder.successCodes) { "A non-null value must be provided for successCodes" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ResponseInspectionStatusCode = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResponseInspectionStatusCode(")
        append("failureCodes=$failureCodes,")
        append("successCodes=$successCodes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = failureCodes.hashCode()
        result = 31 * result + (successCodes.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResponseInspectionStatusCode

        if (failureCodes != other.failureCodes) return false
        if (successCodes != other.successCodes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ResponseInspectionStatusCode = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Status codes in the response that indicate a failed login or account creation attempt. To be counted as a failure, the response status code must match one of these. Each code must be unique among the success and failure status codes.
         *
         * JSON example: `"FailureCodes": [ 400, 404 ]`
         */
        public var failureCodes: List<Int>? = null
        /**
         * Status codes in the response that indicate a successful login or account creation attempt. To be counted as a success, the response status code must match one of these. Each code must be unique among the success and failure status codes.
         *
         * JSON example: `"SuccessCodes": [ 200, 201 ]`
         */
        public var successCodes: List<Int>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ResponseInspectionStatusCode) : this() {
            this.failureCodes = x.failureCodes
            this.successCodes = x.successCodes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ResponseInspectionStatusCode = ResponseInspectionStatusCode(this)

        internal fun correctErrors(): Builder {
            if (failureCodes == null) failureCodes = emptyList()
            if (successCodes == null) successCodes = emptyList()
            return this
        }
    }
}
