// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.
 *
 * This is part of the `AWSManagedRulesATPRuleSet` configuration in `ManagedRuleGroupConfig`.
 *
 * In these settings, you specify how your application accepts login attempts by providing the request payload type and the names of the fields within the request body where the username and password are provided.
 */
public class RequestInspection private constructor(builder: Builder) {
    /**
     * The name of the field in the request payload that contains your customer's password.
     *
     * How you specify this depends on the request inspection payload type.
     * + For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "password": "THE_PASSWORD" } }`, the password field specification is `/form/password`.
     * + For form encoded payload types, use the HTML form names.For example, for an HTML form with the input element named `password1`, the password field specification is `password1`.
     */
    public val passwordField: aws.sdk.kotlin.services.wafv2.model.PasswordField? = builder.passwordField
    /**
     * The payload type for your login endpoint, either JSON or form encoded.
     */
    public val payloadType: aws.sdk.kotlin.services.wafv2.model.PayloadType = requireNotNull(builder.payloadType) { "A non-null value must be provided for payloadType" }
    /**
     * The name of the field in the request payload that contains your customer's username.
     *
     * How you specify this depends on the request inspection payload type.
     * + For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "username": "THE_USERNAME" } }`, the username field specification is `/form/username`.
     * + For form encoded payload types, use the HTML form names.For example, for an HTML form with the input element named `username1`, the username field specification is `username1`
     */
    public val usernameField: aws.sdk.kotlin.services.wafv2.model.UsernameField? = builder.usernameField

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RequestInspection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RequestInspection(")
        append("passwordField=$passwordField,")
        append("payloadType=$payloadType,")
        append("usernameField=$usernameField")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = passwordField?.hashCode() ?: 0
        result = 31 * result + (payloadType.hashCode())
        result = 31 * result + (usernameField?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RequestInspection

        if (passwordField != other.passwordField) return false
        if (payloadType != other.payloadType) return false
        if (usernameField != other.usernameField) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RequestInspection = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the field in the request payload that contains your customer's password.
         *
         * How you specify this depends on the request inspection payload type.
         * + For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "password": "THE_PASSWORD" } }`, the password field specification is `/form/password`.
         * + For form encoded payload types, use the HTML form names.For example, for an HTML form with the input element named `password1`, the password field specification is `password1`.
         */
        public var passwordField: aws.sdk.kotlin.services.wafv2.model.PasswordField? = null
        /**
         * The payload type for your login endpoint, either JSON or form encoded.
         */
        public var payloadType: aws.sdk.kotlin.services.wafv2.model.PayloadType? = null
        /**
         * The name of the field in the request payload that contains your customer's username.
         *
         * How you specify this depends on the request inspection payload type.
         * + For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "username": "THE_USERNAME" } }`, the username field specification is `/form/username`.
         * + For form encoded payload types, use the HTML form names.For example, for an HTML form with the input element named `username1`, the username field specification is `username1`
         */
        public var usernameField: aws.sdk.kotlin.services.wafv2.model.UsernameField? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RequestInspection) : this() {
            this.passwordField = x.passwordField
            this.payloadType = x.payloadType
            this.usernameField = x.usernameField
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RequestInspection = RequestInspection(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.PasswordField] inside the given [block]
         */
        public fun passwordField(block: aws.sdk.kotlin.services.wafv2.model.PasswordField.Builder.() -> kotlin.Unit) {
            this.passwordField = aws.sdk.kotlin.services.wafv2.model.PasswordField.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.UsernameField] inside the given [block]
         */
        public fun usernameField(block: aws.sdk.kotlin.services.wafv2.model.UsernameField.Builder.() -> kotlin.Unit) {
            this.usernameField = aws.sdk.kotlin.services.wafv2.model.UsernameField.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (payloadType == null) payloadType = PayloadType.SdkUnknown("no value provided")
            return this
        }
    }
}
