// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A rule statement used to search web request components for matches with regular expressions. To use this, create a RegexPatternSet that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set. To create a regex pattern set, see CreateRegexPatternSet.
 *
 * Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.
 */
public class RegexPatternSetReferenceStatement private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the RegexPatternSet that this statement references.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The part of the web request that you want WAF to inspect.
     */
    public val fieldToMatch: aws.sdk.kotlin.services.wafv2.model.FieldToMatch? = builder.fieldToMatch
    /**
     * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
     */
    public val textTransformations: List<TextTransformation> = requireNotNull(builder.textTransformations) { "A non-null value must be provided for textTransformations" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RegexPatternSetReferenceStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegexPatternSetReferenceStatement(")
        append("arn=$arn,")
        append("fieldToMatch=$fieldToMatch,")
        append("textTransformations=$textTransformations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (fieldToMatch?.hashCode() ?: 0)
        result = 31 * result + (textTransformations.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegexPatternSetReferenceStatement

        if (arn != other.arn) return false
        if (fieldToMatch != other.fieldToMatch) return false
        if (textTransformations != other.textTransformations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RegexPatternSetReferenceStatement = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the RegexPatternSet that this statement references.
         */
        public var arn: kotlin.String? = null
        /**
         * The part of the web request that you want WAF to inspect.
         */
        public var fieldToMatch: aws.sdk.kotlin.services.wafv2.model.FieldToMatch? = null
        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
         */
        public var textTransformations: List<TextTransformation>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RegexPatternSetReferenceStatement) : this() {
            this.arn = x.arn
            this.fieldToMatch = x.fieldToMatch
            this.textTransformations = x.textTransformations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RegexPatternSetReferenceStatement = RegexPatternSetReferenceStatement(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.FieldToMatch] inside the given [block]
         */
        public fun fieldToMatch(block: aws.sdk.kotlin.services.wafv2.model.FieldToMatch.Builder.() -> kotlin.Unit) {
            this.fieldToMatch = aws.sdk.kotlin.services.wafv2.model.FieldToMatch.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (textTransformations == null) textTransformations = emptyList()
            return this
        }
    }
}
