// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies a single custom aggregate key for a rate-base rule.
 *
 * Web requests that are missing any of the components specified in the aggregation keys are omitted from the rate-based rule evaluation and handling.
 */
public class RateBasedStatementCustomKey private constructor(builder: Builder) {
    /**
     * Use the value of a cookie in the request as an aggregate key. Each distinct value in the cookie contributes to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation instance.
     */
    public val cookie: aws.sdk.kotlin.services.wafv2.model.RateLimitCookie? = builder.cookie
    /**
     * Use the first IP address in an HTTP header as an aggregate key. Each distinct forwarded IP address contributes to the aggregation instance.
     *
     * When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the forwarded IP address by specifying `FORWARDED_IP` in your rate-based statement's `AggregateKeyType`.
     *
     * With this option, you must specify the header to use in the rate-based rule's `ForwardedIPConfig` property.
     */
    public val forwardedIp: aws.sdk.kotlin.services.wafv2.model.RateLimitForwardedIp? = builder.forwardedIp
    /**
     * Use the value of a header in the request as an aggregate key. Each distinct value in the header contributes to the aggregation instance. If you use a single header as your custom key, then each value fully defines an aggregation instance.
     */
    public val header: aws.sdk.kotlin.services.wafv2.model.RateLimitHeader? = builder.header
    /**
     * Use the request's HTTP method as an aggregate key. Each distinct HTTP method contributes to the aggregation instance. If you use just the HTTP method as your custom key, then each method fully defines an aggregation instance.
     */
    public val httpMethod: aws.sdk.kotlin.services.wafv2.model.RateLimitHttpMethod? = builder.httpMethod
    /**
     * Use the request's originating IP address as an aggregate key. Each distinct IP address contributes to the aggregation instance.
     *
     * When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the IP address by specifying `IP` in your rate-based statement's `AggregateKeyType`.
     */
    public val ip: aws.sdk.kotlin.services.wafv2.model.RateLimitIp? = builder.ip
    /**
     * Use the specified label namespace as an aggregate key. Each distinct fully qualified label name that has the specified label namespace contributes to the aggregation instance. If you use just one label namespace as your custom key, then each label name fully defines an aggregation instance.
     *
     * This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule in the web ACL.
     *
     * For information about label namespaces and names, see [Label syntax and naming requirements](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html) in the *WAF Developer Guide*.
     */
    public val labelNamespace: aws.sdk.kotlin.services.wafv2.model.RateLimitLabelNamespace? = builder.labelNamespace
    /**
     * Use the specified query argument as an aggregate key. Each distinct value for the named query argument contributes to the aggregation instance. If you use a single query argument as your custom key, then each value fully defines an aggregation instance.
     */
    public val queryArgument: aws.sdk.kotlin.services.wafv2.model.RateLimitQueryArgument? = builder.queryArgument
    /**
     * Use the request's query string as an aggregate key. Each distinct string contributes to the aggregation instance. If you use just the query string as your custom key, then each string fully defines an aggregation instance.
     */
    public val queryString: aws.sdk.kotlin.services.wafv2.model.RateLimitQueryString? = builder.queryString
    /**
     * Use the request's URI path as an aggregate key. Each distinct URI path contributes to the aggregation instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation instance.
     */
    public val uriPath: aws.sdk.kotlin.services.wafv2.model.RateLimitUriPath? = builder.uriPath

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RateBasedStatementCustomKey = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RateBasedStatementCustomKey(")
        append("cookie=$cookie,")
        append("forwardedIp=$forwardedIp,")
        append("header=$header,")
        append("httpMethod=$httpMethod,")
        append("ip=$ip,")
        append("labelNamespace=$labelNamespace,")
        append("queryArgument=$queryArgument,")
        append("queryString=$queryString,")
        append("uriPath=$uriPath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cookie?.hashCode() ?: 0
        result = 31 * result + (forwardedIp?.hashCode() ?: 0)
        result = 31 * result + (header?.hashCode() ?: 0)
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (ip?.hashCode() ?: 0)
        result = 31 * result + (labelNamespace?.hashCode() ?: 0)
        result = 31 * result + (queryArgument?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (uriPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RateBasedStatementCustomKey

        if (cookie != other.cookie) return false
        if (forwardedIp != other.forwardedIp) return false
        if (header != other.header) return false
        if (httpMethod != other.httpMethod) return false
        if (ip != other.ip) return false
        if (labelNamespace != other.labelNamespace) return false
        if (queryArgument != other.queryArgument) return false
        if (queryString != other.queryString) return false
        if (uriPath != other.uriPath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RateBasedStatementCustomKey = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Use the value of a cookie in the request as an aggregate key. Each distinct value in the cookie contributes to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation instance.
         */
        public var cookie: aws.sdk.kotlin.services.wafv2.model.RateLimitCookie? = null
        /**
         * Use the first IP address in an HTTP header as an aggregate key. Each distinct forwarded IP address contributes to the aggregation instance.
         *
         * When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the forwarded IP address by specifying `FORWARDED_IP` in your rate-based statement's `AggregateKeyType`.
         *
         * With this option, you must specify the header to use in the rate-based rule's `ForwardedIPConfig` property.
         */
        public var forwardedIp: aws.sdk.kotlin.services.wafv2.model.RateLimitForwardedIp? = null
        /**
         * Use the value of a header in the request as an aggregate key. Each distinct value in the header contributes to the aggregation instance. If you use a single header as your custom key, then each value fully defines an aggregation instance.
         */
        public var header: aws.sdk.kotlin.services.wafv2.model.RateLimitHeader? = null
        /**
         * Use the request's HTTP method as an aggregate key. Each distinct HTTP method contributes to the aggregation instance. If you use just the HTTP method as your custom key, then each method fully defines an aggregation instance.
         */
        public var httpMethod: aws.sdk.kotlin.services.wafv2.model.RateLimitHttpMethod? = null
        /**
         * Use the request's originating IP address as an aggregate key. Each distinct IP address contributes to the aggregation instance.
         *
         * When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the IP address by specifying `IP` in your rate-based statement's `AggregateKeyType`.
         */
        public var ip: aws.sdk.kotlin.services.wafv2.model.RateLimitIp? = null
        /**
         * Use the specified label namespace as an aggregate key. Each distinct fully qualified label name that has the specified label namespace contributes to the aggregation instance. If you use just one label namespace as your custom key, then each label name fully defines an aggregation instance.
         *
         * This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule in the web ACL.
         *
         * For information about label namespaces and names, see [Label syntax and naming requirements](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html) in the *WAF Developer Guide*.
         */
        public var labelNamespace: aws.sdk.kotlin.services.wafv2.model.RateLimitLabelNamespace? = null
        /**
         * Use the specified query argument as an aggregate key. Each distinct value for the named query argument contributes to the aggregation instance. If you use a single query argument as your custom key, then each value fully defines an aggregation instance.
         */
        public var queryArgument: aws.sdk.kotlin.services.wafv2.model.RateLimitQueryArgument? = null
        /**
         * Use the request's query string as an aggregate key. Each distinct string contributes to the aggregation instance. If you use just the query string as your custom key, then each string fully defines an aggregation instance.
         */
        public var queryString: aws.sdk.kotlin.services.wafv2.model.RateLimitQueryString? = null
        /**
         * Use the request's URI path as an aggregate key. Each distinct URI path contributes to the aggregation instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation instance.
         */
        public var uriPath: aws.sdk.kotlin.services.wafv2.model.RateLimitUriPath? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RateBasedStatementCustomKey) : this() {
            this.cookie = x.cookie
            this.forwardedIp = x.forwardedIp
            this.header = x.header
            this.httpMethod = x.httpMethod
            this.ip = x.ip
            this.labelNamespace = x.labelNamespace
            this.queryArgument = x.queryArgument
            this.queryString = x.queryString
            this.uriPath = x.uriPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RateBasedStatementCustomKey = RateBasedStatementCustomKey(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RateLimitCookie] inside the given [block]
         */
        public fun cookie(block: aws.sdk.kotlin.services.wafv2.model.RateLimitCookie.Builder.() -> kotlin.Unit) {
            this.cookie = aws.sdk.kotlin.services.wafv2.model.RateLimitCookie.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RateLimitForwardedIp] inside the given [block]
         */
        public fun forwardedIp(block: aws.sdk.kotlin.services.wafv2.model.RateLimitForwardedIp.Builder.() -> kotlin.Unit) {
            this.forwardedIp = aws.sdk.kotlin.services.wafv2.model.RateLimitForwardedIp.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RateLimitHeader] inside the given [block]
         */
        public fun header(block: aws.sdk.kotlin.services.wafv2.model.RateLimitHeader.Builder.() -> kotlin.Unit) {
            this.header = aws.sdk.kotlin.services.wafv2.model.RateLimitHeader.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RateLimitHttpMethod] inside the given [block]
         */
        public fun httpMethod(block: aws.sdk.kotlin.services.wafv2.model.RateLimitHttpMethod.Builder.() -> kotlin.Unit) {
            this.httpMethod = aws.sdk.kotlin.services.wafv2.model.RateLimitHttpMethod.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RateLimitIp] inside the given [block]
         */
        public fun ip(block: aws.sdk.kotlin.services.wafv2.model.RateLimitIp.Builder.() -> kotlin.Unit) {
            this.ip = aws.sdk.kotlin.services.wafv2.model.RateLimitIp.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RateLimitLabelNamespace] inside the given [block]
         */
        public fun labelNamespace(block: aws.sdk.kotlin.services.wafv2.model.RateLimitLabelNamespace.Builder.() -> kotlin.Unit) {
            this.labelNamespace = aws.sdk.kotlin.services.wafv2.model.RateLimitLabelNamespace.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RateLimitQueryArgument] inside the given [block]
         */
        public fun queryArgument(block: aws.sdk.kotlin.services.wafv2.model.RateLimitQueryArgument.Builder.() -> kotlin.Unit) {
            this.queryArgument = aws.sdk.kotlin.services.wafv2.model.RateLimitQueryArgument.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RateLimitQueryString] inside the given [block]
         */
        public fun queryString(block: aws.sdk.kotlin.services.wafv2.model.RateLimitQueryString.Builder.() -> kotlin.Unit) {
            this.queryString = aws.sdk.kotlin.services.wafv2.model.RateLimitQueryString.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RateLimitUriPath] inside the given [block]
         */
        public fun uriPath(block: aws.sdk.kotlin.services.wafv2.model.RateLimitUriPath.Builder.() -> kotlin.Unit) {
            this.uriPath = aws.sdk.kotlin.services.wafv2.model.RateLimitUriPath.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
