// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines an association between logging destinations and a web ACL resource, for logging from WAF. As part of the association, you can specify parts of the standard logging fields to keep out of the logs and you can specify filters so that you log only a subset of the logging records.
 *
 * You can define one logging destination per web ACL.
 *
 * You can access information about the traffic that WAF inspects using the following steps:
 * + Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose. The name that you give the destination must start with `aws-waf-logs-`. Depending on the type of destination, you might need to configure additional settings or permissions. For configuration requirements and pricing information for each destination type, see [Logging web ACL traffic](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html) in the *WAF Developer Guide*.
 * + Associate your logging destination to your web ACL using a `PutLoggingConfiguration` request.
 *
 * When you successfully enable logging using a `PutLoggingConfiguration` request, WAF creates an additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch Logs log group, WAF creates a resource policy on the log group. For an Amazon S3 bucket, WAF creates a bucket policy. For an Amazon Kinesis Data Firehose, WAF creates a service-linked role.
 *
 * For additional information about web ACL logging, see [Logging web ACL traffic information](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html) in the *WAF Developer Guide*.
 */
public class LoggingConfiguration private constructor(builder: Builder) {
    /**
     * The logging destination configuration that you want to associate with the web ACL.
     *
     * You can associate one logging destination to a web ACL.
     */
    public val logDestinationConfigs: List<String> = requireNotNull(builder.logDestinationConfigs) { "A non-null value must be provided for logDestinationConfigs" }
    /**
     * The owner of the logging configuration, which must be set to `CUSTOMER` for the configurations that you manage.
     *
     * The log scope `SECURITY_LAKE` indicates a configuration that is managed through Amazon Security Lake. You can use Security Lake to collect log and event data from various sources for normalization, analysis, and management. For information, see [Collecting data from Amazon Web Services services](https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html) in the *Amazon Security Lake user guide*.
     *
     * Default: `CUSTOMER`
     */
    public val logScope: aws.sdk.kotlin.services.wafv2.model.LogScope? = builder.logScope
    /**
     * Used to distinguish between various logging options. Currently, there is one option.
     *
     * Default: `WAF_LOGS`
     */
    public val logType: aws.sdk.kotlin.services.wafv2.model.LogType? = builder.logType
    /**
     * Filtering that specifies which web requests are kept in the logs and which are dropped. You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
     */
    public val loggingFilter: aws.sdk.kotlin.services.wafv2.model.LoggingFilter? = builder.loggingFilter
    /**
     * Indicates whether the logging configuration was created by Firewall Manager, as part of an WAF policy configuration. If true, only Firewall Manager can modify or delete the configuration.
     */
    public val managedByFirewallManager: kotlin.Boolean = builder.managedByFirewallManager
    /**
     * The parts of the request that you want to keep out of the logs.
     *
     * For example, if you redact the `SingleHeader` field, the `HEADER` field in the logs will be `REDACTED` for all rules that use the `SingleHeader``FieldToMatch` setting.
     *
     * Redaction applies only to the component that's specified in the rule's `FieldToMatch` setting, so the `SingleHeader` redaction doesn't apply to rules that use the `Headers``FieldToMatch`.
     *
     * You can specify only the following fields for redaction: `UriPath`, `QueryString`, `SingleHeader`, and `Method`.
     *
     * This setting has no impact on request sampling. With request sampling, the only way to exclude fields is by disabling sampling in the web ACL visibility configuration.
     */
    public val redactedFields: List<FieldToMatch>? = builder.redactedFields
    /**
     * The Amazon Resource Name (ARN) of the web ACL that you want to associate with `LogDestinationConfigs`.
     */
    public val resourceArn: kotlin.String = requireNotNull(builder.resourceArn) { "A non-null value must be provided for resourceArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.LoggingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoggingConfiguration(")
        append("logDestinationConfigs=$logDestinationConfigs,")
        append("logScope=$logScope,")
        append("logType=$logType,")
        append("loggingFilter=$loggingFilter,")
        append("managedByFirewallManager=$managedByFirewallManager,")
        append("redactedFields=$redactedFields,")
        append("resourceArn=$resourceArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logDestinationConfigs.hashCode()
        result = 31 * result + (logScope?.hashCode() ?: 0)
        result = 31 * result + (logType?.hashCode() ?: 0)
        result = 31 * result + (loggingFilter?.hashCode() ?: 0)
        result = 31 * result + (managedByFirewallManager.hashCode())
        result = 31 * result + (redactedFields?.hashCode() ?: 0)
        result = 31 * result + (resourceArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoggingConfiguration

        if (logDestinationConfigs != other.logDestinationConfigs) return false
        if (logScope != other.logScope) return false
        if (logType != other.logType) return false
        if (loggingFilter != other.loggingFilter) return false
        if (managedByFirewallManager != other.managedByFirewallManager) return false
        if (redactedFields != other.redactedFields) return false
        if (resourceArn != other.resourceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.LoggingConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The logging destination configuration that you want to associate with the web ACL.
         *
         * You can associate one logging destination to a web ACL.
         */
        public var logDestinationConfigs: List<String>? = null
        /**
         * The owner of the logging configuration, which must be set to `CUSTOMER` for the configurations that you manage.
         *
         * The log scope `SECURITY_LAKE` indicates a configuration that is managed through Amazon Security Lake. You can use Security Lake to collect log and event data from various sources for normalization, analysis, and management. For information, see [Collecting data from Amazon Web Services services](https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html) in the *Amazon Security Lake user guide*.
         *
         * Default: `CUSTOMER`
         */
        public var logScope: aws.sdk.kotlin.services.wafv2.model.LogScope? = null
        /**
         * Used to distinguish between various logging options. Currently, there is one option.
         *
         * Default: `WAF_LOGS`
         */
        public var logType: aws.sdk.kotlin.services.wafv2.model.LogType? = null
        /**
         * Filtering that specifies which web requests are kept in the logs and which are dropped. You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
         */
        public var loggingFilter: aws.sdk.kotlin.services.wafv2.model.LoggingFilter? = null
        /**
         * Indicates whether the logging configuration was created by Firewall Manager, as part of an WAF policy configuration. If true, only Firewall Manager can modify or delete the configuration.
         */
        public var managedByFirewallManager: kotlin.Boolean = false
        /**
         * The parts of the request that you want to keep out of the logs.
         *
         * For example, if you redact the `SingleHeader` field, the `HEADER` field in the logs will be `REDACTED` for all rules that use the `SingleHeader``FieldToMatch` setting.
         *
         * Redaction applies only to the component that's specified in the rule's `FieldToMatch` setting, so the `SingleHeader` redaction doesn't apply to rules that use the `Headers``FieldToMatch`.
         *
         * You can specify only the following fields for redaction: `UriPath`, `QueryString`, `SingleHeader`, and `Method`.
         *
         * This setting has no impact on request sampling. With request sampling, the only way to exclude fields is by disabling sampling in the web ACL visibility configuration.
         */
        public var redactedFields: List<FieldToMatch>? = null
        /**
         * The Amazon Resource Name (ARN) of the web ACL that you want to associate with `LogDestinationConfigs`.
         */
        public var resourceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.LoggingConfiguration) : this() {
            this.logDestinationConfigs = x.logDestinationConfigs
            this.logScope = x.logScope
            this.logType = x.logType
            this.loggingFilter = x.loggingFilter
            this.managedByFirewallManager = x.managedByFirewallManager
            this.redactedFields = x.redactedFields
            this.resourceArn = x.resourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.LoggingConfiguration = LoggingConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.LoggingFilter] inside the given [block]
         */
        public fun loggingFilter(block: aws.sdk.kotlin.services.wafv2.model.LoggingFilter.Builder.() -> kotlin.Unit) {
            this.loggingFilter = aws.sdk.kotlin.services.wafv2.model.LoggingFilter.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (logDestinationConfigs == null) logDestinationConfigs = emptyList()
            if (resourceArn == null) resourceArn = ""
            return this
        }
    }
}
