// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
 *
 * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
 *
 * This configuration is used for GeoMatchStatement and RateBasedStatement. For IPSetReferenceStatement, use IPSetForwardedIPConfig instead.
 *
 * WAF only evaluates the first IP address found in the specified HTTP header.
 */
public class ForwardedIpConfig private constructor(builder: Builder) {
    /**
     * The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.
     *
     * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
     *
     * You can specify the following fallback behaviors:
     * + `MATCH` - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
     * + `NO_MATCH` - Treat the web request as not matching the rule statement.
     */
    public val fallbackBehavior: aws.sdk.kotlin.services.wafv2.model.FallbackBehavior = requireNotNull(builder.fallbackBehavior) { "A non-null value must be provided for fallbackBehavior" }
    /**
     * The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to `X-Forwarded-For`.
     *
     * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
     */
    public val headerName: kotlin.String = requireNotNull(builder.headerName) { "A non-null value must be provided for headerName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ForwardedIpConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ForwardedIpConfig(")
        append("fallbackBehavior=$fallbackBehavior,")
        append("headerName=$headerName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fallbackBehavior.hashCode()
        result = 31 * result + (headerName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ForwardedIpConfig

        if (fallbackBehavior != other.fallbackBehavior) return false
        if (headerName != other.headerName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ForwardedIpConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.
         *
         * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
         *
         * You can specify the following fallback behaviors:
         * + `MATCH` - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
         * + `NO_MATCH` - Treat the web request as not matching the rule statement.
         */
        public var fallbackBehavior: aws.sdk.kotlin.services.wafv2.model.FallbackBehavior? = null
        /**
         * The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to `X-Forwarded-For`.
         *
         * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
         */
        public var headerName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ForwardedIpConfig) : this() {
            this.fallbackBehavior = x.fallbackBehavior
            this.headerName = x.headerName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ForwardedIpConfig = ForwardedIpConfig(this)

        internal fun correctErrors(): Builder {
            if (fallbackBehavior == null) fallbackBehavior = FallbackBehavior.SdkUnknown("no value provided")
            if (headerName == null) headerName = ""
            return this
        }
    }
}
