// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A custom response to send to the client. You can define a custom response for rule actions and default web ACL actions that are set to BlockAction.
 *
 * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *WAF Developer Guide*.
 */
public class CustomResponse private constructor(builder: Builder) {
    /**
     * References the response body that you want WAF to return to the web request client. You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the `CustomResponseBodies` setting for the WebACL or RuleGroup where you want to use it. Then, in the rule action or web ACL default action `BlockAction` setting, you reference the response body using this key.
     */
    public val customResponseBodyKey: kotlin.String? = builder.customResponseBodyKey
    /**
     * The HTTP status code to return to the client.
     *
     * For a list of status codes that you can use in your custom responses, see [Supported status codes for custom response](https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html) in the *WAF Developer Guide*.
     */
    public val responseCode: kotlin.Int = requireNotNull(builder.responseCode) { "A non-null value must be provided for responseCode" }
    /**
     * The HTTP headers to use in the response. You can specify any header name except for `content-type`. Duplicate header names are not allowed.
     *
     * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the *WAF Developer Guide*.
     */
    public val responseHeaders: List<CustomHttpHeader>? = builder.responseHeaders

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.CustomResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomResponse(")
        append("customResponseBodyKey=$customResponseBodyKey,")
        append("responseCode=$responseCode,")
        append("responseHeaders=$responseHeaders")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customResponseBodyKey?.hashCode() ?: 0
        result = 31 * result + (responseCode)
        result = 31 * result + (responseHeaders?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomResponse

        if (customResponseBodyKey != other.customResponseBodyKey) return false
        if (responseCode != other.responseCode) return false
        if (responseHeaders != other.responseHeaders) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.CustomResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * References the response body that you want WAF to return to the web request client. You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the `CustomResponseBodies` setting for the WebACL or RuleGroup where you want to use it. Then, in the rule action or web ACL default action `BlockAction` setting, you reference the response body using this key.
         */
        public var customResponseBodyKey: kotlin.String? = null
        /**
         * The HTTP status code to return to the client.
         *
         * For a list of status codes that you can use in your custom responses, see [Supported status codes for custom response](https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html) in the *WAF Developer Guide*.
         */
        public var responseCode: kotlin.Int? = null
        /**
         * The HTTP headers to use in the response. You can specify any header name except for `content-type`. Duplicate header names are not allowed.
         *
         * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the *WAF Developer Guide*.
         */
        public var responseHeaders: List<CustomHttpHeader>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.CustomResponse) : this() {
            this.customResponseBodyKey = x.customResponseBodyKey
            this.responseCode = x.responseCode
            this.responseHeaders = x.responseHeaders
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.CustomResponse = CustomResponse(this)

        internal fun correctErrors(): Builder {
            if (responseCode == null) responseCode = 0
            return this
        }
    }
}
