// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A custom header for custom request and response handling. This is used in CustomResponse and CustomRequestHandling.
 */
public class CustomHttpHeader private constructor(builder: Builder) {
    /**
     * The name of the custom header.
     *
     * For custom request header insertion, when WAF inserts the header into the request, it prefixes this name `x-amzn-waf-`, to avoid confusion with the headers that are already in the request. For example, for the header name `sample`, WAF inserts the header `x-amzn-waf-sample`.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The value of the custom header.
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.CustomHttpHeader = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomHttpHeader(")
        append("name=$name,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomHttpHeader

        if (name != other.name) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.CustomHttpHeader = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the custom header.
         *
         * For custom request header insertion, when WAF inserts the header into the request, it prefixes this name `x-amzn-waf-`, to avoid confusion with the headers that are already in the request. For example, for the header name `sample`, WAF inserts the header `x-amzn-waf-sample`.
         */
        public var name: kotlin.String? = null
        /**
         * The value of the custom header.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.CustomHttpHeader) : this() {
            this.name = x.name
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.CustomHttpHeader = CustomHttpHeader(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (value == null) value = ""
            return this
        }
    }
}
