// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details for your use of the Bot Control managed rule group, `AWSManagedRulesBotControlRuleSet`. This configuration is used in `ManagedRuleGroupConfig`.
 */
public class AwsManagedRulesBotControlRuleSet private constructor(builder: Builder) {
    /**
     * Applies only to the targeted inspection level.
     *
     * Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity. Machine learning is required for the Bot Control rules `TGT_ML_CoordinatedActivityLow` and `TGT_ML_CoordinatedActivityMedium`, which inspect for anomalous behavior that might indicate distributed, coordinated bot activity.
     *
     * For more information about this choice, see the listing for these rules in the table at [Bot Control rules listing](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html#aws-managed-rule-groups-bot-rules) in the *WAF Developer Guide*.
     *
     * Default: `TRUE`
     */
    public val enableMachineLearning: kotlin.Boolean = builder.enableMachineLearning
    /**
     * The inspection level to use for the Bot Control rule group. The common level is the least expensive. The targeted level includes all common level rules and adds rules with more advanced inspection criteria. For details, see [WAF Bot Control rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html) in the *WAF Developer Guide*.
     */
    public val inspectionLevel: aws.sdk.kotlin.services.wafv2.model.InspectionLevel = requireNotNull(builder.inspectionLevel) { "A non-null value must be provided for inspectionLevel" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesBotControlRuleSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsManagedRulesBotControlRuleSet(")
        append("enableMachineLearning=$enableMachineLearning,")
        append("inspectionLevel=$inspectionLevel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableMachineLearning.hashCode()
        result = 31 * result + (inspectionLevel.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsManagedRulesBotControlRuleSet

        if (enableMachineLearning != other.enableMachineLearning) return false
        if (inspectionLevel != other.inspectionLevel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesBotControlRuleSet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Applies only to the targeted inspection level.
         *
         * Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity. Machine learning is required for the Bot Control rules `TGT_ML_CoordinatedActivityLow` and `TGT_ML_CoordinatedActivityMedium`, which inspect for anomalous behavior that might indicate distributed, coordinated bot activity.
         *
         * For more information about this choice, see the listing for these rules in the table at [Bot Control rules listing](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html#aws-managed-rule-groups-bot-rules) in the *WAF Developer Guide*.
         *
         * Default: `TRUE`
         */
        public var enableMachineLearning: kotlin.Boolean = true
        /**
         * The inspection level to use for the Bot Control rule group. The common level is the least expensive. The targeted level includes all common level rules and adds rules with more advanced inspection criteria. For details, see [WAF Bot Control rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html) in the *WAF Developer Guide*.
         */
        public var inspectionLevel: aws.sdk.kotlin.services.wafv2.model.InspectionLevel? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesBotControlRuleSet) : this() {
            this.enableMachineLearning = x.enableMachineLearning
            this.inspectionLevel = x.inspectionLevel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesBotControlRuleSet = AwsManagedRulesBotControlRuleSet(this)

        internal fun correctErrors(): Builder {
            if (inspectionLevel == null) inspectionLevel = InspectionLevel.SdkUnknown("no value provided")
            return this
        }
    }
}
