// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies custom configurations for the associations between the web ACL and protected resources.
 *
 * Use this to customize the maximum size of the request body that your protected resources forward to WAF for inspection. You can customize this setting for CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified Access resources. The default setting is 16 KB (16,384 bytes).
 *
 * You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see [WAF Pricing](http://aws.amazon.com/waf/pricing/).
 *
 * For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
 */
public class AssociationConfig private constructor(builder: Builder) {
    /**
     * Customizes the maximum size of the request body that your protected CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access resources forward to WAF for inspection. The default size is 16 KB (16,384 bytes). You can change the setting for any of the available resource types.
     *
     * You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see [WAF Pricing](http://aws.amazon.com/waf/pricing/).
     *
     * Example JSON: ` { "API_GATEWAY": "KB_48", "APP_RUNNER_SERVICE": "KB_32" }`
     *
     * For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
     */
    public val requestBody: Map<AssociatedResourceType, RequestBodyAssociatedResourceTypeConfig>? = builder.requestBody

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.AssociationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociationConfig(")
        append("requestBody=$requestBody")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = requestBody?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociationConfig

        if (requestBody != other.requestBody) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.AssociationConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Customizes the maximum size of the request body that your protected CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access resources forward to WAF for inspection. The default size is 16 KB (16,384 bytes). You can change the setting for any of the available resource types.
         *
         * You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see [WAF Pricing](http://aws.amazon.com/waf/pricing/).
         *
         * Example JSON: ` { "API_GATEWAY": "KB_48", "APP_RUNNER_SERVICE": "KB_32" }`
         *
         * For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
         */
        public var requestBody: Map<AssociatedResourceType, RequestBodyAssociatedResourceTypeConfig>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.AssociationConfig) : this() {
            this.requestBody = x.requestBody
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.AssociationConfig = AssociationConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
