// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies that WAF should allow the request and optionally defines additional custom handling for the request.
 *
 * This is used in the context of other settings, for example to specify values for RuleAction and web ACL DefaultAction.
 */
public class AllowAction private constructor(builder: Builder) {
    /**
     * Defines custom handling for the web request.
     *
     * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *WAF Developer Guide*.
     */
    public val customRequestHandling: aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling? = builder.customRequestHandling

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.AllowAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AllowAction(")
        append("customRequestHandling=$customRequestHandling")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customRequestHandling?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AllowAction

        if (customRequestHandling != other.customRequestHandling) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.AllowAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Defines custom handling for the web request.
         *
         * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *WAF Developer Guide*.
         */
        public var customRequestHandling: aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.AllowAction) : this() {
            this.customRequestHandling = x.customRequestHandling
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.AllowAction = AllowAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling] inside the given [block]
         */
        public fun customRequestHandling(block: aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling.Builder.() -> kotlin.Unit) {
            this.customRequestHandling = aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
