// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The name of a field in the request payload that contains part or all of your customer's primary physical address.
 *
 * This data type is used in the `RequestInspectionACFP` data type.
 */
public class AddressField private constructor(builder: Builder) {
    /**
     * The name of a single primary address field.
     *
     * How you specify the address fields depends on the request inspection payload type.
     * + For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }`, the address field idenfiers are `/form/primaryaddressline1`, `/form/primaryaddressline2`, and `/form/primaryaddressline3`.
     * + For form encoded payload types, use the HTML form names.For example, for an HTML form with input elements named `primaryaddressline1`, `primaryaddressline2`, and `primaryaddressline3`, the address fields identifiers are `primaryaddressline1`, `primaryaddressline2`, and `primaryaddressline3`.
     */
    public val identifier: kotlin.String = requireNotNull(builder.identifier) { "A non-null value must be provided for identifier" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.AddressField = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddressField(")
        append("identifier=$identifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identifier.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddressField

        if (identifier != other.identifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.AddressField = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of a single primary address field.
         *
         * How you specify the address fields depends on the request inspection payload type.
         * + For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }`, the address field idenfiers are `/form/primaryaddressline1`, `/form/primaryaddressline2`, and `/form/primaryaddressline3`.
         * + For form encoded payload types, use the HTML form names.For example, for an HTML form with input elements named `primaryaddressline1`, `primaryaddressline2`, and `primaryaddressline3`, the address fields identifiers are `primaryaddressline1`, `primaryaddressline2`, and `primaryaddressline3`.
         */
        public var identifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.AddressField) : this() {
            this.identifier = x.identifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.AddressField = AddressField(this)

        internal fun correctErrors(): Builder {
            if (identifier == null) identifier = ""
            return this
        }
    }
}
