// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.serde

import aws.sdk.kotlin.services.wafv2.model.GetSampledRequestsResponse
import aws.sdk.kotlin.services.wafv2.model.SampledHttpRequest
import aws.sdk.kotlin.services.wafv2.model.TimeWindow
import aws.sdk.kotlin.services.wafv2.model.Wafv2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetSampledRequestsOperationDeserializer: HttpDeserialize<GetSampledRequestsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetSampledRequestsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSampledRequestsError(context, call)
        }
        val builder = GetSampledRequestsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSampledRequestsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetSampledRequestsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw Wafv2Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "WAFNonexistentItemException" -> WafNonexistentItemExceptionDeserializer().deserialize(context, wrappedCall)
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedCall)
        else -> Wafv2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSampledRequestsOperationBody(builder: GetSampledRequestsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val POPULATIONSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("PopulationSize"))
    val SAMPLEDREQUESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SampledRequests"))
    val TIMEWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TimeWindow"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(POPULATIONSIZE_DESCRIPTOR)
        field(SAMPLEDREQUESTS_DESCRIPTOR)
        field(TIMEWINDOW_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                POPULATIONSIZE_DESCRIPTOR.index -> builder.populationSize = deserializeLong()
                SAMPLEDREQUESTS_DESCRIPTOR.index -> builder.sampledRequests =
                    deserializer.deserializeList(SAMPLEDREQUESTS_DESCRIPTOR) {
                        val col0 = mutableListOf<SampledHttpRequest>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSampledHttpRequestDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TIMEWINDOW_DESCRIPTOR.index -> builder.timeWindow = deserializeTimeWindowDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
