// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has a statement that defines what to look for in web requests and an action that WAF applies to requests that match the statement. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types Rule, RuleGroup, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
 */
public class WebAcl private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * Specifies custom configurations for the associations between the web ACL and protected resources.
     *
     * Use this to customize the maximum size of the request body that your protected CloudFront distributions forward to WAF for inspection. The default is 16 KB (16,384 bytes).
     *
     * You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see [WAF Pricing](http://aws.amazon.com/waf/pricing/).
     */
    public val associationConfig: aws.sdk.kotlin.services.wafv2.model.AssociationConfig? = builder.associationConfig
    /**
     * The web ACL capacity units (WCUs) currently being used by this web ACL.
     *
     * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. For more information, see [WAF web ACL capacity units (WCU)](https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html) in the *WAF Developer Guide*.
     */
    public val capacity: kotlin.Long = builder.capacity
    /**
     * Specifies how WAF should handle `CAPTCHA` evaluations for rules that don't have their own `CaptchaConfig` settings. If you don't specify this, WAF uses its default settings for `CaptchaConfig`.
     */
    public val captchaConfig: aws.sdk.kotlin.services.wafv2.model.CaptchaConfig? = builder.captchaConfig
    /**
     * Specifies how WAF should handle challenge evaluations for rules that don't have their own `ChallengeConfig` settings. If you don't specify this, WAF uses its default settings for `ChallengeConfig`.
     */
    public val challengeConfig: aws.sdk.kotlin.services.wafv2.model.ChallengeConfig? = builder.challengeConfig
    /**
     * A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL.
     *
     * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *WAF Developer Guide*.
     *
     * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the *WAF Developer Guide*.
     */
    public val customResponseBodies: Map<String, CustomResponseBody>? = builder.customResponseBodies
    /**
     * The action to perform if none of the `Rules` contained in the `WebACL` match.
     */
    public val defaultAction: aws.sdk.kotlin.services.wafv2.model.DefaultAction? = builder.defaultAction
    /**
     * A description of the web ACL that helps with identification.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the `WebACL`. This ID is returned in the responses to create and list commands. You use this ID to do things like get, update, and delete a `WebACL`.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The label namespace prefix for this web ACL. All labels added by rules in this web ACL have this prefix.
     * + The syntax for the label namespace prefix for a web ACL is the following: `awswaf:<account ID>:webacl:<web ACL name>:`
     * + When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: `<label namespace>:<label from rule>`
     */
    public val labelNamespace: kotlin.String? = builder.labelNamespace
    /**
     * Indicates whether this web ACL is managed by Firewall Manager. If true, then only Firewall Manager can delete the web ACL or any Firewall Manager rule groups in the web ACL.
     */
    public val managedByFirewallManager: kotlin.Boolean = builder.managedByFirewallManager
    /**
     * The name of the web ACL. You cannot change the name of a web ACL after you create it.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The last set of rules for WAF to process in the web ACL. This is defined in an Firewall Manager WAF policy and contains only rule group references. You can't alter these. Any rules and rule groups that you define for the web ACL are prioritized before these.
     *
     * In the Firewall Manager WAF policy, the Firewall Manager administrator can define a set of rule groups to run first in the web ACL and a set of rule groups to run last. Within each set, the administrator prioritizes the rule groups, to determine their relative processing order.
     */
    public val postProcessFirewallManagerRuleGroups: List<FirewallManagerRuleGroup>? = builder.postProcessFirewallManagerRuleGroups
    /**
     * The first set of rules for WAF to process in the web ACL. This is defined in an Firewall Manager WAF policy and contains only rule group references. You can't alter these. Any rules and rule groups that you define for the web ACL are prioritized after these.
     *
     * In the Firewall Manager WAF policy, the Firewall Manager administrator can define a set of rule groups to run first in the web ACL and a set of rule groups to run last. Within each set, the administrator prioritizes the rule groups, to determine their relative processing order.
     */
    public val preProcessFirewallManagerRuleGroups: List<FirewallManagerRuleGroup>? = builder.preProcessFirewallManagerRuleGroups
    /**
     * The Rule statements used to identify the web requests that you want to manage. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them.
     */
    public val rules: List<Rule>? = builder.rules
    /**
     * Specifies the domains that WAF should accept in a web request token. This enables the use of tokens across multiple protected websites. When WAF provides a token, it uses the domain of the Amazon Web Services resource that the web ACL is protecting. If you don't specify a list of token domains, WAF accepts tokens only for the domain of the protected resource. With a token domain list, WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.
     */
    public val tokenDomains: List<String>? = builder.tokenDomains
    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    public val visibilityConfig: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig? = builder.visibilityConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.WebAcl = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WebAcl(")
        append("arn=$arn,")
        append("associationConfig=$associationConfig,")
        append("capacity=$capacity,")
        append("captchaConfig=$captchaConfig,")
        append("challengeConfig=$challengeConfig,")
        append("customResponseBodies=$customResponseBodies,")
        append("defaultAction=$defaultAction,")
        append("description=$description,")
        append("id=$id,")
        append("labelNamespace=$labelNamespace,")
        append("managedByFirewallManager=$managedByFirewallManager,")
        append("name=$name,")
        append("postProcessFirewallManagerRuleGroups=$postProcessFirewallManagerRuleGroups,")
        append("preProcessFirewallManagerRuleGroups=$preProcessFirewallManagerRuleGroups,")
        append("rules=$rules,")
        append("tokenDomains=$tokenDomains,")
        append("visibilityConfig=$visibilityConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (associationConfig?.hashCode() ?: 0)
        result = 31 * result + (capacity.hashCode())
        result = 31 * result + (captchaConfig?.hashCode() ?: 0)
        result = 31 * result + (challengeConfig?.hashCode() ?: 0)
        result = 31 * result + (customResponseBodies?.hashCode() ?: 0)
        result = 31 * result + (defaultAction?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (labelNamespace?.hashCode() ?: 0)
        result = 31 * result + (managedByFirewallManager.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (postProcessFirewallManagerRuleGroups?.hashCode() ?: 0)
        result = 31 * result + (preProcessFirewallManagerRuleGroups?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        result = 31 * result + (tokenDomains?.hashCode() ?: 0)
        result = 31 * result + (visibilityConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WebAcl

        if (arn != other.arn) return false
        if (associationConfig != other.associationConfig) return false
        if (capacity != other.capacity) return false
        if (captchaConfig != other.captchaConfig) return false
        if (challengeConfig != other.challengeConfig) return false
        if (customResponseBodies != other.customResponseBodies) return false
        if (defaultAction != other.defaultAction) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (labelNamespace != other.labelNamespace) return false
        if (managedByFirewallManager != other.managedByFirewallManager) return false
        if (name != other.name) return false
        if (postProcessFirewallManagerRuleGroups != other.postProcessFirewallManagerRuleGroups) return false
        if (preProcessFirewallManagerRuleGroups != other.preProcessFirewallManagerRuleGroups) return false
        if (rules != other.rules) return false
        if (tokenDomains != other.tokenDomains) return false
        if (visibilityConfig != other.visibilityConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.WebAcl = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.
         */
        public var arn: kotlin.String? = null
        /**
         * Specifies custom configurations for the associations between the web ACL and protected resources.
         *
         * Use this to customize the maximum size of the request body that your protected CloudFront distributions forward to WAF for inspection. The default is 16 KB (16,384 bytes).
         *
         * You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see [WAF Pricing](http://aws.amazon.com/waf/pricing/).
         */
        public var associationConfig: aws.sdk.kotlin.services.wafv2.model.AssociationConfig? = null
        /**
         * The web ACL capacity units (WCUs) currently being used by this web ACL.
         *
         * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. For more information, see [WAF web ACL capacity units (WCU)](https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html) in the *WAF Developer Guide*.
         */
        public var capacity: kotlin.Long = 0L
        /**
         * Specifies how WAF should handle `CAPTCHA` evaluations for rules that don't have their own `CaptchaConfig` settings. If you don't specify this, WAF uses its default settings for `CaptchaConfig`.
         */
        public var captchaConfig: aws.sdk.kotlin.services.wafv2.model.CaptchaConfig? = null
        /**
         * Specifies how WAF should handle challenge evaluations for rules that don't have their own `ChallengeConfig` settings. If you don't specify this, WAF uses its default settings for `ChallengeConfig`.
         */
        public var challengeConfig: aws.sdk.kotlin.services.wafv2.model.ChallengeConfig? = null
        /**
         * A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL.
         *
         * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *WAF Developer Guide*.
         *
         * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the *WAF Developer Guide*.
         */
        public var customResponseBodies: Map<String, CustomResponseBody>? = null
        /**
         * The action to perform if none of the `Rules` contained in the `WebACL` match.
         */
        public var defaultAction: aws.sdk.kotlin.services.wafv2.model.DefaultAction? = null
        /**
         * A description of the web ACL that helps with identification.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the `WebACL`. This ID is returned in the responses to create and list commands. You use this ID to do things like get, update, and delete a `WebACL`.
         */
        public var id: kotlin.String? = null
        /**
         * The label namespace prefix for this web ACL. All labels added by rules in this web ACL have this prefix.
         * + The syntax for the label namespace prefix for a web ACL is the following: `awswaf:<account ID>:webacl:<web ACL name>:`
         * + When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: `<label namespace>:<label from rule>`
         */
        public var labelNamespace: kotlin.String? = null
        /**
         * Indicates whether this web ACL is managed by Firewall Manager. If true, then only Firewall Manager can delete the web ACL or any Firewall Manager rule groups in the web ACL.
         */
        public var managedByFirewallManager: kotlin.Boolean = false
        /**
         * The name of the web ACL. You cannot change the name of a web ACL after you create it.
         */
        public var name: kotlin.String? = null
        /**
         * The last set of rules for WAF to process in the web ACL. This is defined in an Firewall Manager WAF policy and contains only rule group references. You can't alter these. Any rules and rule groups that you define for the web ACL are prioritized before these.
         *
         * In the Firewall Manager WAF policy, the Firewall Manager administrator can define a set of rule groups to run first in the web ACL and a set of rule groups to run last. Within each set, the administrator prioritizes the rule groups, to determine their relative processing order.
         */
        public var postProcessFirewallManagerRuleGroups: List<FirewallManagerRuleGroup>? = null
        /**
         * The first set of rules for WAF to process in the web ACL. This is defined in an Firewall Manager WAF policy and contains only rule group references. You can't alter these. Any rules and rule groups that you define for the web ACL are prioritized after these.
         *
         * In the Firewall Manager WAF policy, the Firewall Manager administrator can define a set of rule groups to run first in the web ACL and a set of rule groups to run last. Within each set, the administrator prioritizes the rule groups, to determine their relative processing order.
         */
        public var preProcessFirewallManagerRuleGroups: List<FirewallManagerRuleGroup>? = null
        /**
         * The Rule statements used to identify the web requests that you want to manage. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them.
         */
        public var rules: List<Rule>? = null
        /**
         * Specifies the domains that WAF should accept in a web request token. This enables the use of tokens across multiple protected websites. When WAF provides a token, it uses the domain of the Amazon Web Services resource that the web ACL is protecting. If you don't specify a list of token domains, WAF accepts tokens only for the domain of the protected resource. With a token domain list, WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.
         */
        public var tokenDomains: List<String>? = null
        /**
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         */
        public var visibilityConfig: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.WebAcl) : this() {
            this.arn = x.arn
            this.associationConfig = x.associationConfig
            this.capacity = x.capacity
            this.captchaConfig = x.captchaConfig
            this.challengeConfig = x.challengeConfig
            this.customResponseBodies = x.customResponseBodies
            this.defaultAction = x.defaultAction
            this.description = x.description
            this.id = x.id
            this.labelNamespace = x.labelNamespace
            this.managedByFirewallManager = x.managedByFirewallManager
            this.name = x.name
            this.postProcessFirewallManagerRuleGroups = x.postProcessFirewallManagerRuleGroups
            this.preProcessFirewallManagerRuleGroups = x.preProcessFirewallManagerRuleGroups
            this.rules = x.rules
            this.tokenDomains = x.tokenDomains
            this.visibilityConfig = x.visibilityConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.WebAcl = WebAcl(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.AssociationConfig] inside the given [block]
         */
        public fun associationConfig(block: aws.sdk.kotlin.services.wafv2.model.AssociationConfig.Builder.() -> kotlin.Unit) {
            this.associationConfig = aws.sdk.kotlin.services.wafv2.model.AssociationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.CaptchaConfig] inside the given [block]
         */
        public fun captchaConfig(block: aws.sdk.kotlin.services.wafv2.model.CaptchaConfig.Builder.() -> kotlin.Unit) {
            this.captchaConfig = aws.sdk.kotlin.services.wafv2.model.CaptchaConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.ChallengeConfig] inside the given [block]
         */
        public fun challengeConfig(block: aws.sdk.kotlin.services.wafv2.model.ChallengeConfig.Builder.() -> kotlin.Unit) {
            this.challengeConfig = aws.sdk.kotlin.services.wafv2.model.ChallengeConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.DefaultAction] inside the given [block]
         */
        public fun defaultAction(block: aws.sdk.kotlin.services.wafv2.model.DefaultAction.Builder.() -> kotlin.Unit) {
            this.defaultAction = aws.sdk.kotlin.services.wafv2.model.DefaultAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.VisibilityConfig] inside the given [block]
         */
        public fun visibilityConfig(block: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig.Builder.() -> kotlin.Unit) {
            this.visibilityConfig = aws.sdk.kotlin.services.wafv2.model.VisibilityConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (id == null) id = ""
            if (name == null) name = ""
            return this
        }
    }
}
