// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A rule statement used to run the rules that are defined in a RuleGroup. To use this, create a rule group with your rules, then provide the ARN of the rule group in this statement.
 *
 * You cannot nest a `RuleGroupReferenceStatement`, for example for use inside a `NotStatement` or `OrStatement`. You cannot use a rule group reference statement inside another rule group. You can only reference a rule group as a top-level statement within a rule that you define in a web ACL.
 */
public class RuleGroupReferenceStatement private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the entity.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * Rules in the referenced rule group whose actions are set to `Count`.
     *
     * Instead of this option, use `RuleActionOverrides`. It accepts any valid action setting, including `Count`.
     */
    public val excludedRules: List<ExcludedRule>? = builder.excludedRules
    /**
     * Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change.
     *
     * You can use overrides for testing, for example you can override all of rule actions to `Count` and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.
     */
    public val ruleActionOverrides: List<RuleActionOverride>? = builder.ruleActionOverrides

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleGroupReferenceStatement(")
        append("arn=$arn,")
        append("excludedRules=$excludedRules,")
        append("ruleActionOverrides=$ruleActionOverrides")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (excludedRules?.hashCode() ?: 0)
        result = 31 * result + (ruleActionOverrides?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleGroupReferenceStatement

        if (arn != other.arn) return false
        if (excludedRules != other.excludedRules) return false
        if (ruleActionOverrides != other.ruleActionOverrides) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the entity.
         */
        public var arn: kotlin.String? = null
        /**
         * Rules in the referenced rule group whose actions are set to `Count`.
         *
         * Instead of this option, use `RuleActionOverrides`. It accepts any valid action setting, including `Count`.
         */
        public var excludedRules: List<ExcludedRule>? = null
        /**
         * Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change.
         *
         * You can use overrides for testing, for example you can override all of rule actions to `Count` and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.
         */
        public var ruleActionOverrides: List<RuleActionOverride>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement) : this() {
            this.arn = x.arn
            this.excludedRules = x.excludedRules
            this.ruleActionOverrides = x.ruleActionOverrides
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement = RuleGroupReferenceStatement(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            return this
        }
    }
}
