// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Configures inspection of the response body. WAF can inspect the first 65,536 bytes (64 KB) of the response body. This is part of the `ResponseInspection` configuration for `AWSManagedRulesATPRuleSet` and `AWSManagedRulesACFPRuleSet`.
 *
 * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
 */
public class ResponseInspectionBodyContains private constructor(builder: Builder) {
    /**
     * Strings in the body of the response that indicate a failed login or account creation attempt. To be counted as a failure, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings.
     *
     * JSON example: `"FailureStrings": [ "Request failed" ]`
     */
    public val failureStrings: List<String> = requireNotNull(builder.failureStrings) { "A non-null value must be provided for failureStrings" }
    /**
     * Strings in the body of the response that indicate a successful login or account creation attempt. To be counted as a success, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings.
     *
     * JSON examples: `"SuccessStrings": [ "Login successful" ]` and `"SuccessStrings": [ "Account creation successful", "Welcome to our site!" ]`
     */
    public val successStrings: List<String> = requireNotNull(builder.successStrings) { "A non-null value must be provided for successStrings" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ResponseInspectionBodyContains = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResponseInspectionBodyContains(")
        append("failureStrings=$failureStrings,")
        append("successStrings=$successStrings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = failureStrings.hashCode()
        result = 31 * result + (successStrings.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResponseInspectionBodyContains

        if (failureStrings != other.failureStrings) return false
        if (successStrings != other.successStrings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ResponseInspectionBodyContains = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Strings in the body of the response that indicate a failed login or account creation attempt. To be counted as a failure, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings.
         *
         * JSON example: `"FailureStrings": [ "Request failed" ]`
         */
        public var failureStrings: List<String>? = null
        /**
         * Strings in the body of the response that indicate a successful login or account creation attempt. To be counted as a success, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings.
         *
         * JSON examples: `"SuccessStrings": [ "Login successful" ]` and `"SuccessStrings": [ "Account creation successful", "Welcome to our site!" ]`
         */
        public var successStrings: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ResponseInspectionBodyContains) : this() {
            this.failureStrings = x.failureStrings
            this.successStrings = x.successStrings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ResponseInspectionBodyContains = ResponseInspectionBodyContains(this)

        internal fun correctErrors(): Builder {
            if (failureStrings == null) failureStrings = emptyList()
            if (successStrings == null) successStrings = emptyList()
            return this
        }
    }
}
