// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track account creation attempts.
 *
 * This is part of the `AWSManagedRulesACFPRuleSet` configuration in `ManagedRuleGroupConfig`.
 *
 * In these settings, you specify how your application accepts account creation attempts by providing the request payload type and the names of the fields within the request body where the username, password, email, and primary address and phone number fields are provided.
 */
public class RequestInspectionAcfp private constructor(builder: Builder) {
    /**
     * The names of the fields in the request payload that contain your customer's primary physical address.
     *
     * Order the address fields in the array exactly as they are ordered in the request payload.
     *
     * How you specify the address fields depends on the request inspection payload type.
     * + For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }`, the address field idenfiers are `/form/primaryaddressline1`, `/form/primaryaddressline2`, and `/form/primaryaddressline3`.
     * + For form encoded payload types, use the HTML form names.For example, for an HTML form with input elements named `primaryaddressline1`, `primaryaddressline2`, and `primaryaddressline3`, the address fields identifiers are `primaryaddressline1`, `primaryaddressline2`, and `primaryaddressline3`.
     */
    public val addressFields: List<AddressField>? = builder.addressFields
    /**
     * The name of the field in the request payload that contains your customer's email.
     *
     * How you specify this depends on the request inspection payload type.
     * + For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "email": "THE_EMAIL" } }`, the email field specification is `/form/email`.
     * + For form encoded payload types, use the HTML form names.For example, for an HTML form with the input element named `email1`, the email field specification is `email1`.
     */
    public val emailField: aws.sdk.kotlin.services.wafv2.model.EmailField? = builder.emailField
    /**
     * The name of the field in the request payload that contains your customer's password.
     *
     * How you specify this depends on the request inspection payload type.
     * + For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "password": "THE_PASSWORD" } }`, the password field specification is `/form/password`.
     * + For form encoded payload types, use the HTML form names.For example, for an HTML form with the input element named `password1`, the password field specification is `password1`.
     */
    public val passwordField: aws.sdk.kotlin.services.wafv2.model.PasswordField? = builder.passwordField
    /**
     * The payload type for your account creation endpoint, either JSON or form encoded.
     */
    public val payloadType: aws.sdk.kotlin.services.wafv2.model.PayloadType = requireNotNull(builder.payloadType) { "A non-null value must be provided for payloadType" }
    /**
     * The names of the fields in the request payload that contain your customer's primary phone number.
     *
     * Order the phone number fields in the array exactly as they are ordered in the request payload.
     *
     * How you specify the phone number fields depends on the request inspection payload type.
     * + For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }`, the phone number field identifiers are `/form/primaryphoneline1`, `/form/primaryphoneline2`, and `/form/primaryphoneline3`.
     * + For form encoded payload types, use the HTML form names.For example, for an HTML form with input elements named `primaryphoneline1`, `primaryphoneline2`, and `primaryphoneline3`, the phone number field identifiers are `primaryphoneline1`, `primaryphoneline2`, and `primaryphoneline3`.
     */
    public val phoneNumberFields: List<PhoneNumberField>? = builder.phoneNumberFields
    /**
     * The name of the field in the request payload that contains your customer's username.
     *
     * How you specify this depends on the request inspection payload type.
     * + For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "username": "THE_USERNAME" } }`, the username field specification is `/form/username`.
     * + For form encoded payload types, use the HTML form names.For example, for an HTML form with the input element named `username1`, the username field specification is `username1`
     */
    public val usernameField: aws.sdk.kotlin.services.wafv2.model.UsernameField? = builder.usernameField

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RequestInspectionAcfp = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RequestInspectionAcfp(")
        append("addressFields=$addressFields,")
        append("emailField=$emailField,")
        append("passwordField=$passwordField,")
        append("payloadType=$payloadType,")
        append("phoneNumberFields=$phoneNumberFields,")
        append("usernameField=$usernameField")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressFields?.hashCode() ?: 0
        result = 31 * result + (emailField?.hashCode() ?: 0)
        result = 31 * result + (passwordField?.hashCode() ?: 0)
        result = 31 * result + (payloadType.hashCode())
        result = 31 * result + (phoneNumberFields?.hashCode() ?: 0)
        result = 31 * result + (usernameField?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RequestInspectionAcfp

        if (addressFields != other.addressFields) return false
        if (emailField != other.emailField) return false
        if (passwordField != other.passwordField) return false
        if (payloadType != other.payloadType) return false
        if (phoneNumberFields != other.phoneNumberFields) return false
        if (usernameField != other.usernameField) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RequestInspectionAcfp = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The names of the fields in the request payload that contain your customer's primary physical address.
         *
         * Order the address fields in the array exactly as they are ordered in the request payload.
         *
         * How you specify the address fields depends on the request inspection payload type.
         * + For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }`, the address field idenfiers are `/form/primaryaddressline1`, `/form/primaryaddressline2`, and `/form/primaryaddressline3`.
         * + For form encoded payload types, use the HTML form names.For example, for an HTML form with input elements named `primaryaddressline1`, `primaryaddressline2`, and `primaryaddressline3`, the address fields identifiers are `primaryaddressline1`, `primaryaddressline2`, and `primaryaddressline3`.
         */
        public var addressFields: List<AddressField>? = null
        /**
         * The name of the field in the request payload that contains your customer's email.
         *
         * How you specify this depends on the request inspection payload type.
         * + For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "email": "THE_EMAIL" } }`, the email field specification is `/form/email`.
         * + For form encoded payload types, use the HTML form names.For example, for an HTML form with the input element named `email1`, the email field specification is `email1`.
         */
        public var emailField: aws.sdk.kotlin.services.wafv2.model.EmailField? = null
        /**
         * The name of the field in the request payload that contains your customer's password.
         *
         * How you specify this depends on the request inspection payload type.
         * + For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "password": "THE_PASSWORD" } }`, the password field specification is `/form/password`.
         * + For form encoded payload types, use the HTML form names.For example, for an HTML form with the input element named `password1`, the password field specification is `password1`.
         */
        public var passwordField: aws.sdk.kotlin.services.wafv2.model.PasswordField? = null
        /**
         * The payload type for your account creation endpoint, either JSON or form encoded.
         */
        public var payloadType: aws.sdk.kotlin.services.wafv2.model.PayloadType? = null
        /**
         * The names of the fields in the request payload that contain your customer's primary phone number.
         *
         * Order the phone number fields in the array exactly as they are ordered in the request payload.
         *
         * How you specify the phone number fields depends on the request inspection payload type.
         * + For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }`, the phone number field identifiers are `/form/primaryphoneline1`, `/form/primaryphoneline2`, and `/form/primaryphoneline3`.
         * + For form encoded payload types, use the HTML form names.For example, for an HTML form with input elements named `primaryphoneline1`, `primaryphoneline2`, and `primaryphoneline3`, the phone number field identifiers are `primaryphoneline1`, `primaryphoneline2`, and `primaryphoneline3`.
         */
        public var phoneNumberFields: List<PhoneNumberField>? = null
        /**
         * The name of the field in the request payload that contains your customer's username.
         *
         * How you specify this depends on the request inspection payload type.
         * + For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "username": "THE_USERNAME" } }`, the username field specification is `/form/username`.
         * + For form encoded payload types, use the HTML form names.For example, for an HTML form with the input element named `username1`, the username field specification is `username1`
         */
        public var usernameField: aws.sdk.kotlin.services.wafv2.model.UsernameField? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RequestInspectionAcfp) : this() {
            this.addressFields = x.addressFields
            this.emailField = x.emailField
            this.passwordField = x.passwordField
            this.payloadType = x.payloadType
            this.phoneNumberFields = x.phoneNumberFields
            this.usernameField = x.usernameField
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RequestInspectionAcfp = RequestInspectionAcfp(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.EmailField] inside the given [block]
         */
        public fun emailField(block: aws.sdk.kotlin.services.wafv2.model.EmailField.Builder.() -> kotlin.Unit) {
            this.emailField = aws.sdk.kotlin.services.wafv2.model.EmailField.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.PasswordField] inside the given [block]
         */
        public fun passwordField(block: aws.sdk.kotlin.services.wafv2.model.PasswordField.Builder.() -> kotlin.Unit) {
            this.passwordField = aws.sdk.kotlin.services.wafv2.model.PasswordField.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.UsernameField] inside the given [block]
         */
        public fun usernameField(block: aws.sdk.kotlin.services.wafv2.model.UsernameField.Builder.() -> kotlin.Unit) {
            this.usernameField = aws.sdk.kotlin.services.wafv2.model.UsernameField.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (payloadType == null) payloadType = PayloadType.SdkUnknown("no value provided")
            return this
        }
    }
}
