// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Customizes the maximum size of the request body that your protected CloudFront distributions forward to WAF for inspection. The default size is 16 KB (16,384 bytes).
 *
 * You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see [WAF Pricing](http://aws.amazon.com/waf/pricing/).
 *
 * This is used in the `AssociationConfig` of the web ACL.
 */
public class RequestBodyAssociatedResourceTypeConfig private constructor(builder: Builder) {
    /**
     * Specifies the maximum size of the web request body component that an associated CloudFront distribution should send to WAF for inspection. This applies to statements in the web ACL that inspect the body or JSON body.
     *
     * Default: `16 KB (16,384 bytes)`
     */
    public val defaultSizeInspectionLimit: aws.sdk.kotlin.services.wafv2.model.SizeInspectionLimit = requireNotNull(builder.defaultSizeInspectionLimit) { "A non-null value must be provided for defaultSizeInspectionLimit" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RequestBodyAssociatedResourceTypeConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RequestBodyAssociatedResourceTypeConfig(")
        append("defaultSizeInspectionLimit=$defaultSizeInspectionLimit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultSizeInspectionLimit.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RequestBodyAssociatedResourceTypeConfig

        if (defaultSizeInspectionLimit != other.defaultSizeInspectionLimit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RequestBodyAssociatedResourceTypeConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the maximum size of the web request body component that an associated CloudFront distribution should send to WAF for inspection. This applies to statements in the web ACL that inspect the body or JSON body.
         *
         * Default: `16 KB (16,384 bytes)`
         */
        public var defaultSizeInspectionLimit: aws.sdk.kotlin.services.wafv2.model.SizeInspectionLimit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RequestBodyAssociatedResourceTypeConfig) : this() {
            this.defaultSizeInspectionLimit = x.defaultSizeInspectionLimit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RequestBodyAssociatedResourceTypeConfig = RequestBodyAssociatedResourceTypeConfig(this)

        internal fun correctErrors(): Builder {
            if (defaultSizeInspectionLimit == null) defaultSizeInspectionLimit = SizeInspectionLimit.SdkUnknown("no value provided")
            return this
        }
    }
}
