// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Specifies a label namespace to use as an aggregate key for a rate-based rule. Each distinct fully qualified label name that has the specified label namespace contributes to the aggregation instance. If you use just one label namespace as your custom key, then each label name fully defines an aggregation instance.
 *
 * This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule in the web ACL.
 *
 * For information about label namespaces and names, see [Label syntax and naming requirements](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html) in the *WAF Developer Guide*.
 */
public class RateLimitLabelNamespace private constructor(builder: Builder) {
    /**
     * The namespace to use for aggregation.
     */
    public val namespace: kotlin.String = requireNotNull(builder.namespace) { "A non-null value must be provided for namespace" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RateLimitLabelNamespace = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RateLimitLabelNamespace(")
        append("namespace=$namespace")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = namespace.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RateLimitLabelNamespace

        if (namespace != other.namespace) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RateLimitLabelNamespace = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The namespace to use for aggregation.
         */
        public var namespace: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RateLimitLabelNamespace) : this() {
            this.namespace = x.namespace
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RateLimitLabelNamespace = RateLimitLabelNamespace(this)

        internal fun correctErrors(): Builder {
            if (namespace == null) namespace = ""
            return this
        }
    }
}
