// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * The name of a field in the request payload that contains part or all of your customer's primary phone number.
 *
 * This data type is used in the `RequestInspectionACFP` data type.
 */
public class PhoneNumberField private constructor(builder: Builder) {
    /**
     * The name of a single primary phone number field.
     *
     * How you specify the phone number fields depends on the request inspection payload type.
     * + For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }`, the phone number field identifiers are `/form/primaryphoneline1`, `/form/primaryphoneline2`, and `/form/primaryphoneline3`.
     * + For form encoded payload types, use the HTML form names.For example, for an HTML form with input elements named `primaryphoneline1`, `primaryphoneline2`, and `primaryphoneline3`, the phone number field identifiers are `primaryphoneline1`, `primaryphoneline2`, and `primaryphoneline3`.
     */
    public val identifier: kotlin.String = requireNotNull(builder.identifier) { "A non-null value must be provided for identifier" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.PhoneNumberField = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PhoneNumberField(")
        append("identifier=$identifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identifier.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PhoneNumberField

        if (identifier != other.identifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.PhoneNumberField = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of a single primary phone number field.
         *
         * How you specify the phone number fields depends on the request inspection payload type.
         * + For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://tools.ietf.org/html/rfc6901). For example, for the JSON payload `{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }`, the phone number field identifiers are `/form/primaryphoneline1`, `/form/primaryphoneline2`, and `/form/primaryphoneline3`.
         * + For form encoded payload types, use the HTML form names.For example, for an HTML form with input elements named `primaryphoneline1`, `primaryphoneline2`, and `primaryphoneline3`, the phone number field identifiers are `primaryphoneline1`, `primaryphoneline2`, and `primaryphoneline3`.
         */
        public var identifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.PhoneNumberField) : this() {
            this.identifier = x.identifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.PhoneNumberField = PhoneNumberField(this)

        internal fun correctErrors(): Builder {
            if (identifier == null) identifier = ""
            return this
        }
    }
}
