// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Additional information that's used by a managed rule group. Many managed rule groups don't require this.
 *
 * The rule groups used for intelligent threat mitigation require additional configuration:
 * + Use the `AWSManagedRulesACFPRuleSet` configuration object to configure the account creation fraud prevention managed rule group. The configuration includes the registration and sign-up pages of your application and the locations in the account creation request payload of data, such as the user email and phone number fields.
 * + Use the `AWSManagedRulesATPRuleSet` configuration object to configure the account takeover prevention managed rule group. The configuration includes the sign-in page of your application and the locations in the login request payload of data such as the username and password.
 * + Use the `AWSManagedRulesBotControlRuleSet` configuration object to configure the protection level that you want the Bot Control rule group to use.
 *
 * For example specifications, see the examples section of CreateWebACL.
 */
public class ManagedRuleGroupConfig private constructor(builder: Builder) {
    /**
     * Additional configuration for using the account creation fraud prevention (ACFP) managed rule group, `AWSManagedRulesACFPRuleSet`. Use this to provide account creation request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to account creation requests.
     *
     * For information about using the ACFP managed rule group, see [WAF Fraud Control account creation fraud prevention (ACFP) rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-acfp.html) and [WAF Fraud Control account creation fraud prevention (ACFP)](https://docs.aws.amazon.com/waf/latest/developerguide/waf-acfp.html) in the *WAF Developer Guide*.
     */
    public val awsManagedRulesAcfpRuleSet: aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesAcfpRuleSet? = builder.awsManagedRulesAcfpRuleSet
    /**
     * Additional configuration for using the account takeover prevention (ATP) managed rule group, `AWSManagedRulesATPRuleSet`. Use this to provide login request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to login requests.
     *
     * This configuration replaces the individual configuration fields in `ManagedRuleGroupConfig` and provides additional feature configuration.
     *
     * For information about using the ATP managed rule group, see [WAF Fraud Control account takeover prevention (ATP) rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-atp.html) and [WAF Fraud Control account takeover prevention (ATP)](https://docs.aws.amazon.com/waf/latest/developerguide/waf-atp.html) in the *WAF Developer Guide*.
     */
    public val awsManagedRulesAtpRuleSet: aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesAtpRuleSet? = builder.awsManagedRulesAtpRuleSet
    /**
     * Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection level that you want to use. For information about using the Bot Control managed rule group, see [WAF Bot Control rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html) and [WAF Bot Control](https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html) in the *WAF Developer Guide*.
     */
    public val awsManagedRulesBotControlRuleSet: aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesBotControlRuleSet? = builder.awsManagedRulesBotControlRuleSet
    /**
     * Instead of this setting, provide your configuration under `AWSManagedRulesATPRuleSet`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val loginPath: kotlin.String? = builder.loginPath
    /**
     * Instead of this setting, provide your configuration under the request inspection configuration for `AWSManagedRulesATPRuleSet` or `AWSManagedRulesACFPRuleSet`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val passwordField: aws.sdk.kotlin.services.wafv2.model.PasswordField? = builder.passwordField
    /**
     * Instead of this setting, provide your configuration under the request inspection configuration for `AWSManagedRulesATPRuleSet` or `AWSManagedRulesACFPRuleSet`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val payloadType: aws.sdk.kotlin.services.wafv2.model.PayloadType? = builder.payloadType
    /**
     * Instead of this setting, provide your configuration under the request inspection configuration for `AWSManagedRulesATPRuleSet` or `AWSManagedRulesACFPRuleSet`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val usernameField: aws.sdk.kotlin.services.wafv2.model.UsernameField? = builder.usernameField

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ManagedRuleGroupConfig(")
        append("awsManagedRulesAcfpRuleSet=$awsManagedRulesAcfpRuleSet,")
        append("awsManagedRulesAtpRuleSet=$awsManagedRulesAtpRuleSet,")
        append("awsManagedRulesBotControlRuleSet=$awsManagedRulesBotControlRuleSet,")
        append("loginPath=$loginPath,")
        append("passwordField=$passwordField,")
        append("payloadType=$payloadType,")
        append("usernameField=$usernameField")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsManagedRulesAcfpRuleSet?.hashCode() ?: 0
        result = 31 * result + (awsManagedRulesAtpRuleSet?.hashCode() ?: 0)
        result = 31 * result + (awsManagedRulesBotControlRuleSet?.hashCode() ?: 0)
        result = 31 * result + (loginPath?.hashCode() ?: 0)
        result = 31 * result + (passwordField?.hashCode() ?: 0)
        result = 31 * result + (payloadType?.hashCode() ?: 0)
        result = 31 * result + (usernameField?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ManagedRuleGroupConfig

        if (awsManagedRulesAcfpRuleSet != other.awsManagedRulesAcfpRuleSet) return false
        if (awsManagedRulesAtpRuleSet != other.awsManagedRulesAtpRuleSet) return false
        if (awsManagedRulesBotControlRuleSet != other.awsManagedRulesBotControlRuleSet) return false
        if (loginPath != other.loginPath) return false
        if (passwordField != other.passwordField) return false
        if (payloadType != other.payloadType) return false
        if (usernameField != other.usernameField) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Additional configuration for using the account creation fraud prevention (ACFP) managed rule group, `AWSManagedRulesACFPRuleSet`. Use this to provide account creation request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to account creation requests.
         *
         * For information about using the ACFP managed rule group, see [WAF Fraud Control account creation fraud prevention (ACFP) rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-acfp.html) and [WAF Fraud Control account creation fraud prevention (ACFP)](https://docs.aws.amazon.com/waf/latest/developerguide/waf-acfp.html) in the *WAF Developer Guide*.
         */
        public var awsManagedRulesAcfpRuleSet: aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesAcfpRuleSet? = null
        /**
         * Additional configuration for using the account takeover prevention (ATP) managed rule group, `AWSManagedRulesATPRuleSet`. Use this to provide login request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to login requests.
         *
         * This configuration replaces the individual configuration fields in `ManagedRuleGroupConfig` and provides additional feature configuration.
         *
         * For information about using the ATP managed rule group, see [WAF Fraud Control account takeover prevention (ATP) rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-atp.html) and [WAF Fraud Control account takeover prevention (ATP)](https://docs.aws.amazon.com/waf/latest/developerguide/waf-atp.html) in the *WAF Developer Guide*.
         */
        public var awsManagedRulesAtpRuleSet: aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesAtpRuleSet? = null
        /**
         * Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection level that you want to use. For information about using the Bot Control managed rule group, see [WAF Bot Control rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html) and [WAF Bot Control](https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html) in the *WAF Developer Guide*.
         */
        public var awsManagedRulesBotControlRuleSet: aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesBotControlRuleSet? = null
        /**
         * Instead of this setting, provide your configuration under `AWSManagedRulesATPRuleSet`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var loginPath: kotlin.String? = null
        /**
         * Instead of this setting, provide your configuration under the request inspection configuration for `AWSManagedRulesATPRuleSet` or `AWSManagedRulesACFPRuleSet`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var passwordField: aws.sdk.kotlin.services.wafv2.model.PasswordField? = null
        /**
         * Instead of this setting, provide your configuration under the request inspection configuration for `AWSManagedRulesATPRuleSet` or `AWSManagedRulesACFPRuleSet`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var payloadType: aws.sdk.kotlin.services.wafv2.model.PayloadType? = null
        /**
         * Instead of this setting, provide your configuration under the request inspection configuration for `AWSManagedRulesATPRuleSet` or `AWSManagedRulesACFPRuleSet`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var usernameField: aws.sdk.kotlin.services.wafv2.model.UsernameField? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupConfig) : this() {
            this.awsManagedRulesAcfpRuleSet = x.awsManagedRulesAcfpRuleSet
            this.awsManagedRulesAtpRuleSet = x.awsManagedRulesAtpRuleSet
            this.awsManagedRulesBotControlRuleSet = x.awsManagedRulesBotControlRuleSet
            this.loginPath = x.loginPath
            this.passwordField = x.passwordField
            this.payloadType = x.payloadType
            this.usernameField = x.usernameField
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupConfig = ManagedRuleGroupConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesAcfpRuleSet] inside the given [block]
         */
        public fun awsManagedRulesAcfpRuleSet(block: aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesAcfpRuleSet.Builder.() -> kotlin.Unit) {
            this.awsManagedRulesAcfpRuleSet = aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesAcfpRuleSet.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesAtpRuleSet] inside the given [block]
         */
        public fun awsManagedRulesAtpRuleSet(block: aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesAtpRuleSet.Builder.() -> kotlin.Unit) {
            this.awsManagedRulesAtpRuleSet = aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesAtpRuleSet.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesBotControlRuleSet] inside the given [block]
         */
        public fun awsManagedRulesBotControlRuleSet(block: aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesBotControlRuleSet.Builder.() -> kotlin.Unit) {
            this.awsManagedRulesBotControlRuleSet = aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesBotControlRuleSet.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.PasswordField] inside the given [block]
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public fun passwordField(block: aws.sdk.kotlin.services.wafv2.model.PasswordField.Builder.() -> kotlin.Unit) {
            this.passwordField = aws.sdk.kotlin.services.wafv2.model.PasswordField.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.UsernameField] inside the given [block]
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public fun usernameField(block: aws.sdk.kotlin.services.wafv2.model.UsernameField.Builder.() -> kotlin.Unit) {
            this.usernameField = aws.sdk.kotlin.services.wafv2.model.UsernameField.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
